package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateResourcePool invokes the emr.CreateResourcePool API synchronously
func (client *Client) CreateResourcePool(request *CreateResourcePoolRequest) (response *CreateResourcePoolResponse, err error) {
	response = CreateCreateResourcePoolResponse()
	err = client.DoAction(request, response)
	return
}

// CreateResourcePoolWithChan invokes the emr.CreateResourcePool API asynchronously
func (client *Client) CreateResourcePoolWithChan(request *CreateResourcePoolRequest) (<-chan *CreateResourcePoolResponse, <-chan error) {
	responseChan := make(chan *CreateResourcePoolResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateResourcePool(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateResourcePoolWithCallback invokes the emr.CreateResourcePool API asynchronously
func (client *Client) CreateResourcePoolWithCallback(request *CreateResourcePoolRequest, callback func(response *CreateResourcePoolResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateResourcePoolResponse
		var err error
		defer close(result)
		response, err = client.CreateResourcePool(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateResourcePoolRequest is the request struct for api CreateResourcePool
type CreateResourcePoolRequest struct {
	*requests.RpcRequest
	Note            string                      `position:"Query" name:"Note"`
	ResourceOwnerId requests.Integer            `position:"Query" name:"ResourceOwnerId"`
	Active          requests.Boolean            `position:"Query" name:"Active"`
	ClusterId       string                      `position:"Query" name:"ClusterId"`
	YarnSiteConfig  string                      `position:"Query" name:"YarnSiteConfig"`
	Name            string                      `position:"Query" name:"Name"`
	Config          *[]CreateResourcePoolConfig `position:"Query" name:"Config"  type:"Repeated"`
	PoolType        string                      `position:"Query" name:"PoolType"`
}

// CreateResourcePoolConfig is a repeated param struct in CreateResourcePoolRequest
type CreateResourcePoolConfig struct {
	ConfigKey   string `name:"ConfigKey"`
	Note        string `name:"Note"`
	ConfigType  string `name:"configType"`
	TargetId    string `name:"TargetId"`
	ConfigValue string `name:"ConfigValue"`
	Category    string `name:"Category"`
}

// CreateResourcePoolResponse is the response struct for api CreateResourcePool
type CreateResourcePoolResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateResourcePoolRequest creates a request to invoke CreateResourcePool API
func CreateCreateResourcePoolRequest() (request *CreateResourcePoolRequest) {
	request = &CreateResourcePoolRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CreateResourcePool", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateResourcePoolResponse creates a response to parse from CreateResourcePool response
func CreateCreateResourcePoolResponse() (response *CreateResourcePoolResponse) {
	response = &CreateResourcePoolResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
