package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenDiagnosis invokes the elasticsearch.OpenDiagnosis API synchronously
func (client *Client) OpenDiagnosis(request *OpenDiagnosisRequest) (response *OpenDiagnosisResponse, err error) {
	response = CreateOpenDiagnosisResponse()
	err = client.DoAction(request, response)
	return
}

// OpenDiagnosisWithChan invokes the elasticsearch.OpenDiagnosis API asynchronously
func (client *Client) OpenDiagnosisWithChan(request *OpenDiagnosisRequest) (<-chan *OpenDiagnosisResponse, <-chan error) {
	responseChan := make(chan *OpenDiagnosisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenDiagnosis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenDiagnosisWithCallback invokes the elasticsearch.OpenDiagnosis API asynchronously
func (client *Client) OpenDiagnosisWithCallback(request *OpenDiagnosisRequest, callback func(response *OpenDiagnosisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenDiagnosisResponse
		var err error
		defer close(result)
		response, err = client.OpenDiagnosis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenDiagnosisRequest is the request struct for api OpenDiagnosis
type OpenDiagnosisRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"ClientToken"`
	Lang        string `position:"Query" name:"lang"`
}

// OpenDiagnosisResponse is the response struct for api OpenDiagnosis
type OpenDiagnosisResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateOpenDiagnosisRequest creates a request to invoke OpenDiagnosis API
func CreateOpenDiagnosisRequest() (request *OpenDiagnosisRequest) {
	request = &OpenDiagnosisRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "OpenDiagnosis", "/openapi/diagnosis/instances/[InstanceId]/actions/open-diagnosis", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOpenDiagnosisResponse creates a response to parse from OpenDiagnosis response
func CreateOpenDiagnosisResponse() (response *OpenDiagnosisResponse) {
	response = &OpenDiagnosisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
