package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPipelineIds invokes the elasticsearch.ListPipelineIds API synchronously
func (client *Client) ListPipelineIds(request *ListPipelineIdsRequest) (response *ListPipelineIdsResponse, err error) {
	response = CreateListPipelineIdsResponse()
	err = client.DoAction(request, response)
	return
}

// ListPipelineIdsWithChan invokes the elasticsearch.ListPipelineIds API asynchronously
func (client *Client) ListPipelineIdsWithChan(request *ListPipelineIdsRequest) (<-chan *ListPipelineIdsResponse, <-chan error) {
	responseChan := make(chan *ListPipelineIdsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPipelineIds(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPipelineIdsWithCallback invokes the elasticsearch.ListPipelineIds API asynchronously
func (client *Client) ListPipelineIdsWithCallback(request *ListPipelineIdsRequest, callback func(response *ListPipelineIdsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPipelineIdsResponse
		var err error
		defer close(result)
		response, err = client.ListPipelineIds(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPipelineIdsRequest is the request struct for api ListPipelineIds
type ListPipelineIdsRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// ListPipelineIdsResponse is the response struct for api ListPipelineIds
type ListPipelineIdsResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateListPipelineIdsRequest creates a request to invoke ListPipelineIds API
func CreateListPipelineIdsRequest() (request *ListPipelineIdsRequest) {
	request = &ListPipelineIdsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ListPipelineIds", "/openapi/instances/[InstanceId]/pipeline-ids", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListPipelineIdsResponse creates a response to parse from ListPipelineIds response
func CreateListPipelineIdsResponse() (response *ListPipelineIdsResponse) {
	response = &ListPipelineIdsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
