package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEmonMonitorData invokes the elasticsearch.GetEmonMonitorData API synchronously
func (client *Client) GetEmonMonitorData(request *GetEmonMonitorDataRequest) (response *GetEmonMonitorDataResponse, err error) {
	response = CreateGetEmonMonitorDataResponse()
	err = client.DoAction(request, response)
	return
}

// GetEmonMonitorDataWithChan invokes the elasticsearch.GetEmonMonitorData API asynchronously
func (client *Client) GetEmonMonitorDataWithChan(request *GetEmonMonitorDataRequest) (<-chan *GetEmonMonitorDataResponse, <-chan error) {
	responseChan := make(chan *GetEmonMonitorDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEmonMonitorData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEmonMonitorDataWithCallback invokes the elasticsearch.GetEmonMonitorData API asynchronously
func (client *Client) GetEmonMonitorDataWithCallback(request *GetEmonMonitorDataRequest, callback func(response *GetEmonMonitorDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEmonMonitorDataResponse
		var err error
		defer close(result)
		response, err = client.GetEmonMonitorData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEmonMonitorDataRequest is the request struct for api GetEmonMonitorData
type GetEmonMonitorDataRequest struct {
	*requests.RoaRequest
	ProjectId string `position:"Path" name:"ProjectId"`
}

// GetEmonMonitorDataResponse is the response struct for api GetEmonMonitorData
type GetEmonMonitorDataResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Code      string   `json:"Code" xml:"Code"`
	Message   string   `json:"Message" xml:"Message"`
	Success   bool     `json:"Success" xml:"Success"`
	Result    []Result `json:"Result" xml:"Result"`
}

// CreateGetEmonMonitorDataRequest creates a request to invoke GetEmonMonitorData API
func CreateGetEmonMonitorDataRequest() (request *GetEmonMonitorDataRequest) {
	request = &GetEmonMonitorDataRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "GetEmonMonitorData", "/openapi/emon/projects/[ProjectId]/metrics/query", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetEmonMonitorDataResponse creates a response to parse from GetEmonMonitorData response
func CreateGetEmonMonitorDataResponse() (response *GetEmonMonitorDataResponse) {
	response = &GetEmonMonitorDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
