package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetWorkbenchToken invokes the ehpc.GetWorkbenchToken API synchronously
func (client *Client) GetWorkbenchToken(request *GetWorkbenchTokenRequest) (response *GetWorkbenchTokenResponse, err error) {
	response = CreateGetWorkbenchTokenResponse()
	err = client.DoAction(request, response)
	return
}

// GetWorkbenchTokenWithChan invokes the ehpc.GetWorkbenchToken API asynchronously
func (client *Client) GetWorkbenchTokenWithChan(request *GetWorkbenchTokenRequest) (<-chan *GetWorkbenchTokenResponse, <-chan error) {
	responseChan := make(chan *GetWorkbenchTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetWorkbenchToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetWorkbenchTokenWithCallback invokes the ehpc.GetWorkbenchToken API asynchronously
func (client *Client) GetWorkbenchTokenWithCallback(request *GetWorkbenchTokenRequest, callback func(response *GetWorkbenchTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetWorkbenchTokenResponse
		var err error
		defer close(result)
		response, err = client.GetWorkbenchToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetWorkbenchTokenRequest is the request struct for api GetWorkbenchToken
type GetWorkbenchTokenRequest struct {
	*requests.RpcRequest
	ClusterId            string           `position:"Query" name:"ClusterId"`
	UserPassword         string           `position:"Query" name:"UserPassword"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	Port                 requests.Integer `position:"Query" name:"Port"`
	AccountSessionTicket string           `position:"Query" name:"AccountSessionTicket"`
	AccountUid           string           `position:"Query" name:"AccountUid"`
	UserName             string           `position:"Query" name:"UserName"`
}

// GetWorkbenchTokenResponse is the response struct for api GetWorkbenchToken
type GetWorkbenchTokenResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Root      Root   `json:"root" xml:"root"`
}

// CreateGetWorkbenchTokenRequest creates a request to invoke GetWorkbenchToken API
func CreateGetWorkbenchTokenRequest() (request *GetWorkbenchTokenRequest) {
	request = &GetWorkbenchTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "GetWorkbenchToken", "", "")
	request.Method = requests.GET
	return
}

// CreateGetWorkbenchTokenResponse creates a response to parse from GetWorkbenchToken response
func CreateGetWorkbenchTokenResponse() (response *GetWorkbenchTokenResponse) {
	response = &GetWorkbenchTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
