package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateHookConfiguration invokes the edas.UpdateHookConfiguration API synchronously
func (client *Client) UpdateHookConfiguration(request *UpdateHookConfigurationRequest) (response *UpdateHookConfigurationResponse, err error) {
	response = CreateUpdateHookConfigurationResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateHookConfigurationWithChan invokes the edas.UpdateHookConfiguration API asynchronously
func (client *Client) UpdateHookConfigurationWithChan(request *UpdateHookConfigurationRequest) (<-chan *UpdateHookConfigurationResponse, <-chan error) {
	responseChan := make(chan *UpdateHookConfigurationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateHookConfiguration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateHookConfigurationWithCallback invokes the edas.UpdateHookConfiguration API asynchronously
func (client *Client) UpdateHookConfigurationWithCallback(request *UpdateHookConfigurationRequest, callback func(response *UpdateHookConfigurationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateHookConfigurationResponse
		var err error
		defer close(result)
		response, err = client.UpdateHookConfiguration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateHookConfigurationRequest is the request struct for api UpdateHookConfiguration
type UpdateHookConfigurationRequest struct {
	*requests.RoaRequest
	AppId   string `position:"Query" name:"AppId"`
	GroupId string `position:"Query" name:"GroupId"`
	Hooks   string `position:"Query" name:"Hooks"`
}

// UpdateHookConfigurationResponse is the response struct for api UpdateHookConfiguration
type UpdateHookConfigurationResponse struct {
	*responses.BaseResponse
	RequestId          string          `json:"RequestId" xml:"RequestId"`
	Code               int             `json:"Code" xml:"Code"`
	Message            string          `json:"Message" xml:"Message"`
	HooksConfiguration []Configuration `json:"HooksConfiguration" xml:"HooksConfiguration"`
}

// CreateUpdateHookConfigurationRequest creates a request to invoke UpdateHookConfiguration API
func CreateUpdateHookConfigurationRequest() (request *UpdateHookConfigurationRequest) {
	request = &UpdateHookConfigurationRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "UpdateHookConfiguration", "/pop/app/config_app_hook_json", "edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateHookConfigurationResponse creates a response to parse from UpdateHookConfiguration response
func CreateUpdateHookConfigurationResponse() (response *UpdateHookConfigurationResponse) {
	response = &UpdateHookConfigurationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
