package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateApplicationBaseInfo invokes the edas.UpdateApplicationBaseInfo API synchronously
func (client *Client) UpdateApplicationBaseInfo(request *UpdateApplicationBaseInfoRequest) (response *UpdateApplicationBaseInfoResponse, err error) {
	response = CreateUpdateApplicationBaseInfoResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateApplicationBaseInfoWithChan invokes the edas.UpdateApplicationBaseInfo API asynchronously
func (client *Client) UpdateApplicationBaseInfoWithChan(request *UpdateApplicationBaseInfoRequest) (<-chan *UpdateApplicationBaseInfoResponse, <-chan error) {
	responseChan := make(chan *UpdateApplicationBaseInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateApplicationBaseInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateApplicationBaseInfoWithCallback invokes the edas.UpdateApplicationBaseInfo API asynchronously
func (client *Client) UpdateApplicationBaseInfoWithCallback(request *UpdateApplicationBaseInfoRequest, callback func(response *UpdateApplicationBaseInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateApplicationBaseInfoResponse
		var err error
		defer close(result)
		response, err = client.UpdateApplicationBaseInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateApplicationBaseInfoRequest is the request struct for api UpdateApplicationBaseInfo
type UpdateApplicationBaseInfoRequest struct {
	*requests.RoaRequest
	Owner   string `position:"Query" name:"Owner"`
	AppName string `position:"Query" name:"AppName"`
	AppId   string `position:"Query" name:"AppId"`
	Desc    string `position:"Query" name:"Desc"`
}

// UpdateApplicationBaseInfoResponse is the response struct for api UpdateApplicationBaseInfo
type UpdateApplicationBaseInfoResponse struct {
	*responses.BaseResponse
	Code       int        `json:"Code" xml:"Code"`
	Message    string     `json:"Message" xml:"Message"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Applcation Applcation `json:"Applcation" xml:"Applcation"`
}

// CreateUpdateApplicationBaseInfoRequest creates a request to invoke UpdateApplicationBaseInfo API
func CreateUpdateApplicationBaseInfoRequest() (request *UpdateApplicationBaseInfoRequest) {
	request = &UpdateApplicationBaseInfoRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "UpdateApplicationBaseInfo", "/pop/v5/app/update_app_info", "edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateApplicationBaseInfoResponse creates a response to parse from UpdateApplicationBaseInfo response
func CreateUpdateApplicationBaseInfoResponse() (response *UpdateApplicationBaseInfoResponse) {
	response = &UpdateApplicationBaseInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
