package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ToggleGrayIngress invokes the edas.ToggleGrayIngress API synchronously
func (client *Client) ToggleGrayIngress(request *ToggleGrayIngressRequest) (response *ToggleGrayIngressResponse, err error) {
	response = CreateToggleGrayIngressResponse()
	err = client.DoAction(request, response)
	return
}

// ToggleGrayIngressWithChan invokes the edas.ToggleGrayIngress API asynchronously
func (client *Client) ToggleGrayIngressWithChan(request *ToggleGrayIngressRequest) (<-chan *ToggleGrayIngressResponse, <-chan error) {
	responseChan := make(chan *ToggleGrayIngressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ToggleGrayIngress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ToggleGrayIngressWithCallback invokes the edas.ToggleGrayIngress API asynchronously
func (client *Client) ToggleGrayIngressWithCallback(request *ToggleGrayIngressRequest, callback func(response *ToggleGrayIngressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ToggleGrayIngressResponse
		var err error
		defer close(result)
		response, err = client.ToggleGrayIngress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ToggleGrayIngressRequest is the request struct for api ToggleGrayIngress
type ToggleGrayIngressRequest struct {
	*requests.RoaRequest
	LogicalRegionId string           `position:"Body" name:"LogicalRegionId"`
	Enable          requests.Boolean `position:"Body" name:"Enable"`
	PointcutName    string           `position:"Body" name:"PointcutName"`
}

// ToggleGrayIngressResponse is the response struct for api ToggleGrayIngress
type ToggleGrayIngressResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   int    `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateToggleGrayIngressRequest creates a request to invoke ToggleGrayIngress API
func CreateToggleGrayIngressRequest() (request *ToggleGrayIngressRequest) {
	request = &ToggleGrayIngressRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ToggleGrayIngress", "/pop/v5/gray/env_switch", "edas", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateToggleGrayIngressResponse creates a response to parse from ToggleGrayIngress response
func CreateToggleGrayIngressResponse() (response *ToggleGrayIngressResponse) {
	response = &ToggleGrayIngressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
