package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryK8sClusterLogProjectInfo invokes the edas.QueryK8sClusterLogProjectInfo API synchronously
func (client *Client) QueryK8sClusterLogProjectInfo(request *QueryK8sClusterLogProjectInfoRequest) (response *QueryK8sClusterLogProjectInfoResponse, err error) {
	response = CreateQueryK8sClusterLogProjectInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryK8sClusterLogProjectInfoWithChan invokes the edas.QueryK8sClusterLogProjectInfo API asynchronously
func (client *Client) QueryK8sClusterLogProjectInfoWithChan(request *QueryK8sClusterLogProjectInfoRequest) (<-chan *QueryK8sClusterLogProjectInfoResponse, <-chan error) {
	responseChan := make(chan *QueryK8sClusterLogProjectInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryK8sClusterLogProjectInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryK8sClusterLogProjectInfoWithCallback invokes the edas.QueryK8sClusterLogProjectInfo API asynchronously
func (client *Client) QueryK8sClusterLogProjectInfoWithCallback(request *QueryK8sClusterLogProjectInfoRequest, callback func(response *QueryK8sClusterLogProjectInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryK8sClusterLogProjectInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryK8sClusterLogProjectInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryK8sClusterLogProjectInfoRequest is the request struct for api QueryK8sClusterLogProjectInfo
type QueryK8sClusterLogProjectInfoRequest struct {
	*requests.RoaRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// QueryK8sClusterLogProjectInfoResponse is the response struct for api QueryK8sClusterLogProjectInfo
type QueryK8sClusterLogProjectInfoResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	Code        int         `json:"Code" xml:"Code"`
	Message     string      `json:"Message" xml:"Message"`
	ProjectInfo ProjectInfo `json:"ProjectInfo" xml:"ProjectInfo"`
}

// CreateQueryK8sClusterLogProjectInfoRequest creates a request to invoke QueryK8sClusterLogProjectInfo API
func CreateQueryK8sClusterLogProjectInfoRequest() (request *QueryK8sClusterLogProjectInfoRequest) {
	request = &QueryK8sClusterLogProjectInfoRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "QueryK8sClusterLogProjectInfo", "/pop/v5/k8s/sls/project", "edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateQueryK8sClusterLogProjectInfoResponse creates a response to parse from QueryK8sClusterLogProjectInfo response
func CreateQueryK8sClusterLogProjectInfoResponse() (response *QueryK8sClusterLogProjectInfoResponse) {
	response = &QueryK8sClusterLogProjectInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
