package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEcsNotInCluster invokes the edas.ListEcsNotInCluster API synchronously
func (client *Client) ListEcsNotInCluster(request *ListEcsNotInClusterRequest) (response *ListEcsNotInClusterResponse, err error) {
	response = CreateListEcsNotInClusterResponse()
	err = client.DoAction(request, response)
	return
}

// ListEcsNotInClusterWithChan invokes the edas.ListEcsNotInCluster API asynchronously
func (client *Client) ListEcsNotInClusterWithChan(request *ListEcsNotInClusterRequest) (<-chan *ListEcsNotInClusterResponse, <-chan error) {
	responseChan := make(chan *ListEcsNotInClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEcsNotInCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEcsNotInClusterWithCallback invokes the edas.ListEcsNotInCluster API asynchronously
func (client *Client) ListEcsNotInClusterWithCallback(request *ListEcsNotInClusterRequest, callback func(response *ListEcsNotInClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEcsNotInClusterResponse
		var err error
		defer close(result)
		response, err = client.ListEcsNotInCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEcsNotInClusterRequest is the request struct for api ListEcsNotInCluster
type ListEcsNotInClusterRequest struct {
	*requests.RoaRequest
	VpcId       string           `position:"Query" name:"VpcId"`
	NetworkMode requests.Integer `position:"Query" name:"NetworkMode"`
}

// ListEcsNotInClusterResponse is the response struct for api ListEcsNotInCluster
type ListEcsNotInClusterResponse struct {
	*responses.BaseResponse
	Code          int           `json:"Code" xml:"Code"`
	Message       string        `json:"Message" xml:"Message"`
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	EcsEntityList EcsEntityList `json:"EcsEntityList" xml:"EcsEntityList"`
}

// CreateListEcsNotInClusterRequest creates a request to invoke ListEcsNotInCluster API
func CreateListEcsNotInClusterRequest() (request *ListEcsNotInClusterRequest) {
	request = &ListEcsNotInClusterRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ListEcsNotInCluster", "/pop/v5/resource/ecs_not_in_cluster", "edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListEcsNotInClusterResponse creates a response to parse from ListEcsNotInCluster response
func CreateListEcsNotInClusterResponse() (response *ListEcsNotInClusterResponse) {
	response = &ListEcsNotInClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
