package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCSBGateway invokes the edas.ListCSBGateway API synchronously
func (client *Client) ListCSBGateway(request *ListCSBGatewayRequest) (response *ListCSBGatewayResponse, err error) {
	response = CreateListCSBGatewayResponse()
	err = client.DoAction(request, response)
	return
}

// ListCSBGatewayWithChan invokes the edas.ListCSBGateway API asynchronously
func (client *Client) ListCSBGatewayWithChan(request *ListCSBGatewayRequest) (<-chan *ListCSBGatewayResponse, <-chan error) {
	responseChan := make(chan *ListCSBGatewayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCSBGateway(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCSBGatewayWithCallback invokes the edas.ListCSBGateway API asynchronously
func (client *Client) ListCSBGatewayWithCallback(request *ListCSBGatewayRequest, callback func(response *ListCSBGatewayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCSBGatewayResponse
		var err error
		defer close(result)
		response, err = client.ListCSBGateway(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCSBGatewayRequest is the request struct for api ListCSBGateway
type ListCSBGatewayRequest struct {
	*requests.RoaRequest
	LogicalRegionId string `position:"Query" name:"LogicalRegionId"`
}

// ListCSBGatewayResponse is the response struct for api ListCSBGateway
type ListCSBGatewayResponse struct {
	*responses.BaseResponse
	Code      int                            `json:"Code" xml:"Code"`
	Message   string                         `json:"Message" xml:"Message"`
	RequestId string                         `json:"RequestId" xml:"RequestId"`
	Data      []FindGatewaysResponseBodyData `json:"Data" xml:"Data"`
}

// CreateListCSBGatewayRequest creates a request to invoke ListCSBGateway API
func CreateListCSBGatewayRequest() (request *ListCSBGatewayRequest) {
	request = &ListCSBGatewayRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ListCSBGateway", "/pop/v5/csbgateway/gateway", "edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListCSBGatewayResponse creates a response to parse from ListCSBGateway response
func CreateListCSBGatewayResponse() (response *ListCSBGatewayResponse) {
	response = &ListCSBGatewayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
