package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InsertCluster invokes the edas.InsertCluster API synchronously
func (client *Client) InsertCluster(request *InsertClusterRequest) (response *InsertClusterResponse, err error) {
	response = CreateInsertClusterResponse()
	err = client.DoAction(request, response)
	return
}

// InsertClusterWithChan invokes the edas.InsertCluster API asynchronously
func (client *Client) InsertClusterWithChan(request *InsertClusterRequest) (<-chan *InsertClusterResponse, <-chan error) {
	responseChan := make(chan *InsertClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InsertCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InsertClusterWithCallback invokes the edas.InsertCluster API asynchronously
func (client *Client) InsertClusterWithCallback(request *InsertClusterRequest, callback func(response *InsertClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InsertClusterResponse
		var err error
		defer close(result)
		response, err = client.InsertCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InsertClusterRequest is the request struct for api InsertCluster
type InsertClusterRequest struct {
	*requests.RoaRequest
	ClusterType     requests.Integer `position:"Query" name:"ClusterType"`
	IaasProvider    string           `position:"Query" name:"IaasProvider"`
	LogicalRegionId string           `position:"Query" name:"LogicalRegionId"`
	ClusterName     string           `position:"Query" name:"ClusterName"`
	VpcId           string           `position:"Query" name:"VpcId"`
	NetworkMode     requests.Integer `position:"Query" name:"NetworkMode"`
	OversoldFactor  requests.Integer `position:"Query" name:"OversoldFactor"`
}

// InsertClusterResponse is the response struct for api InsertCluster
type InsertClusterResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Cluster   Cluster `json:"Cluster" xml:"Cluster"`
}

// CreateInsertClusterRequest creates a request to invoke InsertCluster API
func CreateInsertClusterRequest() (request *InsertClusterRequest) {
	request = &InsertClusterRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "InsertCluster", "/pop/v5/resource/cluster", "edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateInsertClusterResponse creates a response to parse from InsertCluster response
func CreateInsertClusterResponse() (response *InsertClusterResponse) {
	response = &InsertClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
