package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSwimmingLane invokes the edas.GetSwimmingLane API synchronously
func (client *Client) GetSwimmingLane(request *GetSwimmingLaneRequest) (response *GetSwimmingLaneResponse, err error) {
	response = CreateGetSwimmingLaneResponse()
	err = client.DoAction(request, response)
	return
}

// GetSwimmingLaneWithChan invokes the edas.GetSwimmingLane API asynchronously
func (client *Client) GetSwimmingLaneWithChan(request *GetSwimmingLaneRequest) (<-chan *GetSwimmingLaneResponse, <-chan error) {
	responseChan := make(chan *GetSwimmingLaneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSwimmingLane(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSwimmingLaneWithCallback invokes the edas.GetSwimmingLane API asynchronously
func (client *Client) GetSwimmingLaneWithCallback(request *GetSwimmingLaneRequest, callback func(response *GetSwimmingLaneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSwimmingLaneResponse
		var err error
		defer close(result)
		response, err = client.GetSwimmingLane(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSwimmingLaneRequest is the request struct for api GetSwimmingLane
type GetSwimmingLaneRequest struct {
	*requests.RoaRequest
	LaneId requests.Integer `position:"Query" name:"LaneId"`
}

// GetSwimmingLaneResponse is the response struct for api GetSwimmingLane
type GetSwimmingLaneResponse struct {
	*responses.BaseResponse
	Code      int                   `json:"Code" xml:"Code"`
	Message   string                `json:"Message" xml:"Message"`
	RequestId string                `json:"RequestId" xml:"RequestId"`
	Data      DataInGetSwimmingLane `json:"Data" xml:"Data"`
}

// CreateGetSwimmingLaneRequest creates a request to invoke GetSwimmingLane API
func CreateGetSwimmingLaneRequest() (request *GetSwimmingLaneRequest) {
	request = &GetSwimmingLaneRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "GetSwimmingLane", "/pop/v5/trafficmgnt/swimming_lane", "edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetSwimmingLaneResponse creates a response to parse from GetSwimmingLane response
func CreateGetSwimmingLaneResponse() (response *GetSwimmingLaneResponse) {
	response = &GetSwimmingLaneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
