package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetK8sServices invokes the edas.GetK8sServices API synchronously
func (client *Client) GetK8sServices(request *GetK8sServicesRequest) (response *GetK8sServicesResponse, err error) {
	response = CreateGetK8sServicesResponse()
	err = client.DoAction(request, response)
	return
}

// GetK8sServicesWithChan invokes the edas.GetK8sServices API asynchronously
func (client *Client) GetK8sServicesWithChan(request *GetK8sServicesRequest) (<-chan *GetK8sServicesResponse, <-chan error) {
	responseChan := make(chan *GetK8sServicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetK8sServices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetK8sServicesWithCallback invokes the edas.GetK8sServices API asynchronously
func (client *Client) GetK8sServicesWithCallback(request *GetK8sServicesRequest, callback func(response *GetK8sServicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetK8sServicesResponse
		var err error
		defer close(result)
		response, err = client.GetK8sServices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetK8sServicesRequest is the request struct for api GetK8sServices
type GetK8sServicesRequest struct {
	*requests.RoaRequest
	AppId string `position:"Query" name:"AppId"`
}

// GetK8sServicesResponse is the response struct for api GetK8sServices
type GetK8sServicesResponse struct {
	*responses.BaseResponse
	Code      int            `json:"Code" xml:"Code"`
	Message   string         `json:"Message" xml:"Message"`
	RequestId string         `json:"RequestId" xml:"RequestId"`
	Services  []ServicesItem `json:"Services" xml:"Services"`
}

// CreateGetK8sServicesRequest creates a request to invoke GetK8sServices API
func CreateGetK8sServicesRequest() (request *GetK8sServicesRequest) {
	request = &GetK8sServicesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "GetK8sServices", "/pop/v5/k8s/acs/k8s_service", "edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetK8sServicesResponse creates a response to parse from GetK8sServices response
func CreateGetK8sServicesResponse() (response *GetK8sServicesResponse) {
	response = &GetK8sServicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
