package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateK8sConfigMap invokes the edas.CreateK8sConfigMap API synchronously
func (client *Client) CreateK8sConfigMap(request *CreateK8sConfigMapRequest) (response *CreateK8sConfigMapResponse, err error) {
	response = CreateCreateK8sConfigMapResponse()
	err = client.DoAction(request, response)
	return
}

// CreateK8sConfigMapWithChan invokes the edas.CreateK8sConfigMap API asynchronously
func (client *Client) CreateK8sConfigMapWithChan(request *CreateK8sConfigMapRequest) (<-chan *CreateK8sConfigMapResponse, <-chan error) {
	responseChan := make(chan *CreateK8sConfigMapResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateK8sConfigMap(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateK8sConfigMapWithCallback invokes the edas.CreateK8sConfigMap API asynchronously
func (client *Client) CreateK8sConfigMapWithCallback(request *CreateK8sConfigMapRequest, callback func(response *CreateK8sConfigMapResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateK8sConfigMapResponse
		var err error
		defer close(result)
		response, err = client.CreateK8sConfigMap(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateK8sConfigMapRequest is the request struct for api CreateK8sConfigMap
type CreateK8sConfigMapRequest struct {
	*requests.RoaRequest
	Data      string `position:"Body" name:"Data"`
	Namespace string `position:"Body" name:"Namespace"`
	Name      string `position:"Body" name:"Name"`
	ClusterId string `position:"Body" name:"ClusterId"`
}

// CreateK8sConfigMapResponse is the response struct for api CreateK8sConfigMap
type CreateK8sConfigMapResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateCreateK8sConfigMapRequest creates a request to invoke CreateK8sConfigMap API
func CreateCreateK8sConfigMapRequest() (request *CreateK8sConfigMapRequest) {
	request = &CreateK8sConfigMapRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "CreateK8sConfigMap", "/pop/v5/k8s/acs/k8s_config_map", "edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateK8sConfigMapResponse creates a response to parse from CreateK8sConfigMap response
func CreateCreateK8sConfigMapResponse() (response *CreateK8sConfigMapResponse) {
	response = &CreateK8sConfigMapResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
