package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateGrayEnvironment invokes the edas.CreateGrayEnvironment API synchronously
func (client *Client) CreateGrayEnvironment(request *CreateGrayEnvironmentRequest) (response *CreateGrayEnvironmentResponse, err error) {
	response = CreateCreateGrayEnvironmentResponse()
	err = client.DoAction(request, response)
	return
}

// CreateGrayEnvironmentWithChan invokes the edas.CreateGrayEnvironment API asynchronously
func (client *Client) CreateGrayEnvironmentWithChan(request *CreateGrayEnvironmentRequest) (<-chan *CreateGrayEnvironmentResponse, <-chan error) {
	responseChan := make(chan *CreateGrayEnvironmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateGrayEnvironment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateGrayEnvironmentWithCallback invokes the edas.CreateGrayEnvironment API asynchronously
func (client *Client) CreateGrayEnvironmentWithCallback(request *CreateGrayEnvironmentRequest, callback func(response *CreateGrayEnvironmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateGrayEnvironmentResponse
		var err error
		defer close(result)
		response, err = client.CreateGrayEnvironment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateGrayEnvironmentRequest is the request struct for api CreateGrayEnvironment
type CreateGrayEnvironmentRequest struct {
	*requests.RoaRequest
	ShowName        string `position:"Body" name:"ShowName"`
	LogicalRegionId string `position:"Body" name:"LogicalRegionId"`
	Description     string `position:"Body" name:"Description"`
	Tag             string `position:"Body" name:"Tag"`
}

// CreateGrayEnvironmentResponse is the response struct for api CreateGrayEnvironment
type CreateGrayEnvironmentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateGrayEnvironmentRequest creates a request to invoke CreateGrayEnvironment API
func CreateCreateGrayEnvironmentRequest() (request *CreateGrayEnvironmentRequest) {
	request = &CreateGrayEnvironmentRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "CreateGrayEnvironment", "/pop/v5/gray/env", "edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateGrayEnvironmentResponse creates a response to parse from CreateGrayEnvironment response
func CreateCreateGrayEnvironmentResponse() (response *CreateGrayEnvironmentResponse) {
	response = &CreateGrayEnvironmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
