package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddShortUrl invokes the dysmsapi.AddShortUrl API synchronously
func (client *Client) AddShortUrl(request *AddShortUrlRequest) (response *AddShortUrlResponse, err error) {
	response = CreateAddShortUrlResponse()
	err = client.DoAction(request, response)
	return
}

// AddShortUrlWithChan invokes the dysmsapi.AddShortUrl API asynchronously
func (client *Client) AddShortUrlWithChan(request *AddShortUrlRequest) (<-chan *AddShortUrlResponse, <-chan error) {
	responseChan := make(chan *AddShortUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddShortUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddShortUrlWithCallback invokes the dysmsapi.AddShortUrl API asynchronously
func (client *Client) AddShortUrlWithCallback(request *AddShortUrlRequest, callback func(response *AddShortUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddShortUrlResponse
		var err error
		defer close(result)
		response, err = client.AddShortUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddShortUrlRequest is the request struct for api AddShortUrl
type AddShortUrlRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ShortUrlName         string           `position:"Body" name:"ShortUrlName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	EffectiveDays        string           `position:"Body" name:"EffectiveDays"`
	ProdCode             string           `position:"Body" name:"ProdCode"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SourceUrl            string           `position:"Body" name:"SourceUrl"`
}

// AddShortUrlResponse is the response struct for api AddShortUrl
type AddShortUrlResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateAddShortUrlRequest creates a request to invoke AddShortUrl API
func CreateAddShortUrlRequest() (request *AddShortUrlRequest) {
	request = &AddShortUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2017-05-25", "AddShortUrl", "", "")
	request.Method = requests.POST
	return
}

// CreateAddShortUrlResponse creates a response to parse from AddShortUrl response
func CreateAddShortUrlResponse() (response *AddShortUrlResponse) {
	response = &AddShortUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
