package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfirmTransferInEmail invokes the domain.ConfirmTransferInEmail API synchronously
func (client *Client) ConfirmTransferInEmail(request *ConfirmTransferInEmailRequest) (response *ConfirmTransferInEmailResponse, err error) {
	response = CreateConfirmTransferInEmailResponse()
	err = client.DoAction(request, response)
	return
}

// ConfirmTransferInEmailWithChan invokes the domain.ConfirmTransferInEmail API asynchronously
func (client *Client) ConfirmTransferInEmailWithChan(request *ConfirmTransferInEmailRequest) (<-chan *ConfirmTransferInEmailResponse, <-chan error) {
	responseChan := make(chan *ConfirmTransferInEmailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfirmTransferInEmail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfirmTransferInEmailWithCallback invokes the domain.ConfirmTransferInEmail API asynchronously
func (client *Client) ConfirmTransferInEmailWithCallback(request *ConfirmTransferInEmailRequest, callback func(response *ConfirmTransferInEmailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfirmTransferInEmailResponse
		var err error
		defer close(result)
		response, err = client.ConfirmTransferInEmail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfirmTransferInEmailRequest is the request struct for api ConfirmTransferInEmail
type ConfirmTransferInEmailRequest struct {
	*requests.RpcRequest
	DomainName   *[]string `position:"Query" name:"DomainName"  type:"Repeated"`
	UserClientIp string    `position:"Query" name:"UserClientIp"`
	Lang         string    `position:"Query" name:"Lang"`
	Email        string    `position:"Query" name:"Email"`
}

// ConfirmTransferInEmailResponse is the response struct for api ConfirmTransferInEmail
type ConfirmTransferInEmailResponse struct {
	*responses.BaseResponse
	RequestId   string                              `json:"RequestId" xml:"RequestId"`
	SuccessList SuccessListInConfirmTransferInEmail `json:"SuccessList" xml:"SuccessList"`
	FailList    FailListInConfirmTransferInEmail    `json:"FailList" xml:"FailList"`
}

// CreateConfirmTransferInEmailRequest creates a request to invoke ConfirmTransferInEmail API
func CreateConfirmTransferInEmailRequest() (request *ConfirmTransferInEmailRequest) {
	request = &ConfirmTransferInEmailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "ConfirmTransferInEmail", "", "")
	request.Method = requests.POST
	return
}

// CreateConfirmTransferInEmailResponse creates a response to parse from ConfirmTransferInEmail response
func CreateConfirmTransferInEmailResponse() (response *ConfirmTransferInEmailResponse) {
	response = &ConfirmTransferInEmailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
