package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPhysicalDatabase invokes the dms_enterprise.GetPhysicalDatabase API synchronously
func (client *Client) GetPhysicalDatabase(request *GetPhysicalDatabaseRequest) (response *GetPhysicalDatabaseResponse, err error) {
	response = CreateGetPhysicalDatabaseResponse()
	err = client.DoAction(request, response)
	return
}

// GetPhysicalDatabaseWithChan invokes the dms_enterprise.GetPhysicalDatabase API asynchronously
func (client *Client) GetPhysicalDatabaseWithChan(request *GetPhysicalDatabaseRequest) (<-chan *GetPhysicalDatabaseResponse, <-chan error) {
	responseChan := make(chan *GetPhysicalDatabaseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPhysicalDatabase(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPhysicalDatabaseWithCallback invokes the dms_enterprise.GetPhysicalDatabase API asynchronously
func (client *Client) GetPhysicalDatabaseWithCallback(request *GetPhysicalDatabaseRequest, callback func(response *GetPhysicalDatabaseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPhysicalDatabaseResponse
		var err error
		defer close(result)
		response, err = client.GetPhysicalDatabase(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPhysicalDatabaseRequest is the request struct for api GetPhysicalDatabase
type GetPhysicalDatabaseRequest struct {
	*requests.RpcRequest
	DbId requests.Integer `position:"Query" name:"DbId"`
	Tid  requests.Integer `position:"Query" name:"Tid"`
}

// GetPhysicalDatabaseResponse is the response struct for api GetPhysicalDatabase
type GetPhysicalDatabaseResponse struct {
	*responses.BaseResponse
	RequestId    string   `json:"RequestId" xml:"RequestId"`
	ErrorCode    string   `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string   `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool     `json:"Success" xml:"Success"`
	Database     Database `json:"Database" xml:"Database"`
}

// CreateGetPhysicalDatabaseRequest creates a request to invoke GetPhysicalDatabase API
func CreateGetPhysicalDatabaseRequest() (request *GetPhysicalDatabaseRequest) {
	request = &GetPhysicalDatabaseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetPhysicalDatabase", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetPhysicalDatabaseResponse creates a response to parse from GetPhysicalDatabase response
func CreateGetPhysicalDatabaseResponse() (response *GetPhysicalDatabaseResponse) {
	response = &GetPhysicalDatabaseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
