package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDBTaskSQLJobLog invokes the dms_enterprise.GetDBTaskSQLJobLog API synchronously
func (client *Client) GetDBTaskSQLJobLog(request *GetDBTaskSQLJobLogRequest) (response *GetDBTaskSQLJobLogResponse, err error) {
	response = CreateGetDBTaskSQLJobLogResponse()
	err = client.DoAction(request, response)
	return
}

// GetDBTaskSQLJobLogWithChan invokes the dms_enterprise.GetDBTaskSQLJobLog API asynchronously
func (client *Client) GetDBTaskSQLJobLogWithChan(request *GetDBTaskSQLJobLogRequest) (<-chan *GetDBTaskSQLJobLogResponse, <-chan error) {
	responseChan := make(chan *GetDBTaskSQLJobLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDBTaskSQLJobLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDBTaskSQLJobLogWithCallback invokes the dms_enterprise.GetDBTaskSQLJobLog API asynchronously
func (client *Client) GetDBTaskSQLJobLogWithCallback(request *GetDBTaskSQLJobLogRequest, callback func(response *GetDBTaskSQLJobLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDBTaskSQLJobLogResponse
		var err error
		defer close(result)
		response, err = client.GetDBTaskSQLJobLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDBTaskSQLJobLogRequest is the request struct for api GetDBTaskSQLJobLog
type GetDBTaskSQLJobLogRequest struct {
	*requests.RpcRequest
	JobId requests.Integer `position:"Query" name:"JobId"`
	Tid   requests.Integer `position:"Query" name:"Tid"`
}

// GetDBTaskSQLJobLogResponse is the response struct for api GetDBTaskSQLJobLog
type GetDBTaskSQLJobLogResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	Log          string `json:"Log" xml:"Log"`
}

// CreateGetDBTaskSQLJobLogRequest creates a request to invoke GetDBTaskSQLJobLog API
func CreateGetDBTaskSQLJobLogRequest() (request *GetDBTaskSQLJobLogRequest) {
	request = &GetDBTaskSQLJobLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetDBTaskSQLJobLog", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDBTaskSQLJobLogResponse creates a response to parse from GetDBTaskSQLJobLog response
func CreateGetDBTaskSQLJobLogResponse() (response *GetDBTaskSQLJobLogResponse) {
	response = &GetDBTaskSQLJobLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
