package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomainSlsStatus invokes the ddoscoo.DescribeDomainSlsStatus API synchronously
func (client *Client) DescribeDomainSlsStatus(request *DescribeDomainSlsStatusRequest) (response *DescribeDomainSlsStatusResponse, err error) {
	response = CreateDescribeDomainSlsStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainSlsStatusWithChan invokes the ddoscoo.DescribeDomainSlsStatus API asynchronously
func (client *Client) DescribeDomainSlsStatusWithChan(request *DescribeDomainSlsStatusRequest) (<-chan *DescribeDomainSlsStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainSlsStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomainSlsStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainSlsStatusWithCallback invokes the ddoscoo.DescribeDomainSlsStatus API asynchronously
func (client *Client) DescribeDomainSlsStatusWithCallback(request *DescribeDomainSlsStatusRequest, callback func(response *DescribeDomainSlsStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainSlsStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomainSlsStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainSlsStatusRequest is the request struct for api DescribeDomainSlsStatus
type DescribeDomainSlsStatusRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	Domain          string `position:"Query" name:"Domain"`
	Lang            string `position:"Query" name:"Lang"`
}

// DescribeDomainSlsStatusResponse is the response struct for api DescribeDomainSlsStatus
type DescribeDomainSlsStatusResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	SlsStatus   bool   `json:"SlsStatus" xml:"SlsStatus"`
	SlsLogstore string `json:"SlsLogstore" xml:"SlsLogstore"`
	SlsProject  string `json:"SlsProject" xml:"SlsProject"`
}

// CreateDescribeDomainSlsStatusRequest creates a request to invoke DescribeDomainSlsStatus API
func CreateDescribeDomainSlsStatusRequest() (request *DescribeDomainSlsStatusRequest) {
	request = &DescribeDomainSlsStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "DescribeDomainSlsStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDomainSlsStatusResponse creates a response to parse from DescribeDomainSlsStatus response
func CreateDescribeDomainSlsStatusResponse() (response *DescribeDomainSlsStatusResponse) {
	response = &DescribeDomainSlsStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
