package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnDomainRealTimeSrcHttpCodeData invokes the dcdn.DescribeDcdnDomainRealTimeSrcHttpCodeData API synchronously
func (client *Client) DescribeDcdnDomainRealTimeSrcHttpCodeData(request *DescribeDcdnDomainRealTimeSrcHttpCodeDataRequest) (response *DescribeDcdnDomainRealTimeSrcHttpCodeDataResponse, err error) {
	response = CreateDescribeDcdnDomainRealTimeSrcHttpCodeDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnDomainRealTimeSrcHttpCodeDataWithChan invokes the dcdn.DescribeDcdnDomainRealTimeSrcHttpCodeData API asynchronously
func (client *Client) DescribeDcdnDomainRealTimeSrcHttpCodeDataWithChan(request *DescribeDcdnDomainRealTimeSrcHttpCodeDataRequest) (<-chan *DescribeDcdnDomainRealTimeSrcHttpCodeDataResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnDomainRealTimeSrcHttpCodeDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnDomainRealTimeSrcHttpCodeData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnDomainRealTimeSrcHttpCodeDataWithCallback invokes the dcdn.DescribeDcdnDomainRealTimeSrcHttpCodeData API asynchronously
func (client *Client) DescribeDcdnDomainRealTimeSrcHttpCodeDataWithCallback(request *DescribeDcdnDomainRealTimeSrcHttpCodeDataRequest, callback func(response *DescribeDcdnDomainRealTimeSrcHttpCodeDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnDomainRealTimeSrcHttpCodeDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnDomainRealTimeSrcHttpCodeData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnDomainRealTimeSrcHttpCodeDataRequest is the request struct for api DescribeDcdnDomainRealTimeSrcHttpCodeData
type DescribeDcdnDomainRealTimeSrcHttpCodeDataRequest struct {
	*requests.RpcRequest
	LocationNameEn string           `position:"Query" name:"LocationNameEn"`
	StartTime      string           `position:"Query" name:"StartTime"`
	IspNameEn      string           `position:"Query" name:"IspNameEn"`
	DomainName     string           `position:"Query" name:"DomainName"`
	EndTime        string           `position:"Query" name:"EndTime"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDcdnDomainRealTimeSrcHttpCodeDataResponse is the response struct for api DescribeDcdnDomainRealTimeSrcHttpCodeData
type DescribeDcdnDomainRealTimeSrcHttpCodeDataResponse struct {
	*responses.BaseResponse
	RequestId               string                  `json:"RequestId" xml:"RequestId"`
	DomainName              string                  `json:"DomainName" xml:"DomainName"`
	StartTime               string                  `json:"StartTime" xml:"StartTime"`
	EndTime                 string                  `json:"EndTime" xml:"EndTime"`
	DataInterval            string                  `json:"DataInterval" xml:"DataInterval"`
	RealTimeSrcHttpCodeData RealTimeSrcHttpCodeData `json:"RealTimeSrcHttpCodeData" xml:"RealTimeSrcHttpCodeData"`
}

// CreateDescribeDcdnDomainRealTimeSrcHttpCodeDataRequest creates a request to invoke DescribeDcdnDomainRealTimeSrcHttpCodeData API
func CreateDescribeDcdnDomainRealTimeSrcHttpCodeDataRequest() (request *DescribeDcdnDomainRealTimeSrcHttpCodeDataRequest) {
	request = &DescribeDcdnDomainRealTimeSrcHttpCodeDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnDomainRealTimeSrcHttpCodeData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnDomainRealTimeSrcHttpCodeDataResponse creates a response to parse from DescribeDcdnDomainRealTimeSrcHttpCodeData response
func CreateDescribeDcdnDomainRealTimeSrcHttpCodeDataResponse() (response *DescribeDcdnDomainRealTimeSrcHttpCodeDataResponse) {
	response = &DescribeDcdnDomainRealTimeSrcHttpCodeDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
