package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOpRiskData invokes the dataworks_public.GetOpRiskData API synchronously
func (client *Client) GetOpRiskData(request *GetOpRiskDataRequest) (response *GetOpRiskDataResponse, err error) {
	response = CreateGetOpRiskDataResponse()
	err = client.DoAction(request, response)
	return
}

// GetOpRiskDataWithChan invokes the dataworks_public.GetOpRiskData API asynchronously
func (client *Client) GetOpRiskDataWithChan(request *GetOpRiskDataRequest) (<-chan *GetOpRiskDataResponse, <-chan error) {
	responseChan := make(chan *GetOpRiskDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOpRiskData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOpRiskDataWithCallback invokes the dataworks_public.GetOpRiskData API asynchronously
func (client *Client) GetOpRiskDataWithCallback(request *GetOpRiskDataRequest, callback func(response *GetOpRiskDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOpRiskDataResponse
		var err error
		defer close(result)
		response, err = client.GetOpRiskData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOpRiskDataRequest is the request struct for api GetOpRiskData
type GetOpRiskDataRequest struct {
	*requests.RpcRequest
	Date     string           `position:"Query" name:"Date"`
	RiskType string           `position:"Query" name:"RiskType"`
	PageNo   requests.Integer `position:"Query" name:"PageNo"`
	PageSize requests.Integer `position:"Query" name:"PageSize"`
	Name     string           `position:"Query" name:"Name"`
}

// GetOpRiskDataResponse is the response struct for api GetOpRiskData
type GetOpRiskDataResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	RiskData  string `json:"RiskData" xml:"RiskData"`
}

// CreateGetOpRiskDataRequest creates a request to invoke GetOpRiskData API
func CreateGetOpRiskDataRequest() (request *GetOpRiskDataRequest) {
	request = &GetOpRiskDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetOpRiskData", "", "")
	request.Method = requests.GET
	return
}

// CreateGetOpRiskDataResponse creates a response to parse from GetOpRiskData response
func CreateGetOpRiskDataResponse() (response *GetOpRiskDataResponse) {
	response = &GetOpRiskDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
