package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PauseClusterUpgrade invokes the cs.PauseClusterUpgrade API synchronously
func (client *Client) PauseClusterUpgrade(request *PauseClusterUpgradeRequest) (response *PauseClusterUpgradeResponse, err error) {
	response = CreatePauseClusterUpgradeResponse()
	err = client.DoAction(request, response)
	return
}

// PauseClusterUpgradeWithChan invokes the cs.PauseClusterUpgrade API asynchronously
func (client *Client) PauseClusterUpgradeWithChan(request *PauseClusterUpgradeRequest) (<-chan *PauseClusterUpgradeResponse, <-chan error) {
	responseChan := make(chan *PauseClusterUpgradeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PauseClusterUpgrade(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PauseClusterUpgradeWithCallback invokes the cs.PauseClusterUpgrade API asynchronously
func (client *Client) PauseClusterUpgradeWithCallback(request *PauseClusterUpgradeRequest, callback func(response *PauseClusterUpgradeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PauseClusterUpgradeResponse
		var err error
		defer close(result)
		response, err = client.PauseClusterUpgrade(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PauseClusterUpgradeRequest is the request struct for api PauseClusterUpgrade
type PauseClusterUpgradeRequest struct {
	*requests.RoaRequest
	ClusterId string `position:"Path" name:"ClusterId"`
}

// PauseClusterUpgradeResponse is the response struct for api PauseClusterUpgrade
type PauseClusterUpgradeResponse struct {
	*responses.BaseResponse
}

// CreatePauseClusterUpgradeRequest creates a request to invoke PauseClusterUpgrade API
func CreatePauseClusterUpgradeRequest() (request *PauseClusterUpgradeRequest) {
	request = &PauseClusterUpgradeRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "PauseClusterUpgrade", "/api/v2/clusters/[ClusterId]/upgrade/pause", "", "")
	request.Method = requests.POST
	return
}

// CreatePauseClusterUpgradeResponse creates a response to parse from PauseClusterUpgrade response
func CreatePauseClusterUpgradeResponse() (response *PauseClusterUpgradeResponse) {
	response = &PauseClusterUpgradeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
