package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAggregators invokes the config.DeleteAggregators API synchronously
func (client *Client) DeleteAggregators(request *DeleteAggregatorsRequest) (response *DeleteAggregatorsResponse, err error) {
	response = CreateDeleteAggregatorsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAggregatorsWithChan invokes the config.DeleteAggregators API asynchronously
func (client *Client) DeleteAggregatorsWithChan(request *DeleteAggregatorsRequest) (<-chan *DeleteAggregatorsResponse, <-chan error) {
	responseChan := make(chan *DeleteAggregatorsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAggregators(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAggregatorsWithCallback invokes the config.DeleteAggregators API asynchronously
func (client *Client) DeleteAggregatorsWithCallback(request *DeleteAggregatorsRequest, callback func(response *DeleteAggregatorsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAggregatorsResponse
		var err error
		defer close(result)
		response, err = client.DeleteAggregators(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAggregatorsRequest is the request struct for api DeleteAggregators
type DeleteAggregatorsRequest struct {
	*requests.RpcRequest
	ClientToken   string `position:"Body" name:"ClientToken"`
	AggregatorIds string `position:"Body" name:"AggregatorIds"`
}

// DeleteAggregatorsResponse is the response struct for api DeleteAggregators
type DeleteAggregatorsResponse struct {
	*responses.BaseResponse
	RequestId                string                   `json:"RequestId" xml:"RequestId"`
	OperateAggregatorsResult OperateAggregatorsResult `json:"OperateAggregatorsResult" xml:"OperateAggregatorsResult"`
}

// CreateDeleteAggregatorsRequest creates a request to invoke DeleteAggregators API
func CreateDeleteAggregatorsRequest() (request *DeleteAggregatorsRequest) {
	request = &DeleteAggregatorsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "DeleteAggregators", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteAggregatorsResponse creates a response to parse from DeleteAggregators response
func CreateDeleteAggregatorsResponse() (response *DeleteAggregatorsResponse) {
	response = &DeleteAggregatorsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
