package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VerifyTaxSmsCode invokes the companyreg.VerifyTaxSmsCode API synchronously
func (client *Client) VerifyTaxSmsCode(request *VerifyTaxSmsCodeRequest) (response *VerifyTaxSmsCodeResponse, err error) {
	response = CreateVerifyTaxSmsCodeResponse()
	err = client.DoAction(request, response)
	return
}

// VerifyTaxSmsCodeWithChan invokes the companyreg.VerifyTaxSmsCode API asynchronously
func (client *Client) VerifyTaxSmsCodeWithChan(request *VerifyTaxSmsCodeRequest) (<-chan *VerifyTaxSmsCodeResponse, <-chan error) {
	responseChan := make(chan *VerifyTaxSmsCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VerifyTaxSmsCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VerifyTaxSmsCodeWithCallback invokes the companyreg.VerifyTaxSmsCode API asynchronously
func (client *Client) VerifyTaxSmsCodeWithCallback(request *VerifyTaxSmsCodeRequest, callback func(response *VerifyTaxSmsCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VerifyTaxSmsCodeResponse
		var err error
		defer close(result)
		response, err = client.VerifyTaxSmsCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VerifyTaxSmsCodeRequest is the request struct for api VerifyTaxSmsCode
type VerifyTaxSmsCodeRequest struct {
	*requests.RpcRequest
	SmsCode string `position:"Query" name:"SmsCode"`
	BizId   string `position:"Query" name:"BizId"`
}

// VerifyTaxSmsCodeResponse is the response struct for api VerifyTaxSmsCode
type VerifyTaxSmsCodeResponse struct {
	*responses.BaseResponse
	Result    bool   `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateVerifyTaxSmsCodeRequest creates a request to invoke VerifyTaxSmsCode API
func CreateVerifyTaxSmsCodeRequest() (request *VerifyTaxSmsCodeRequest) {
	request = &VerifyTaxSmsCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "VerifyTaxSmsCode", "", "")
	request.Method = requests.GET
	return
}

// CreateVerifyTaxSmsCodeResponse creates a response to parse from VerifyTaxSmsCode response
func CreateVerifyTaxSmsCodeResponse() (response *VerifyTaxSmsCodeResponse) {
	response = &VerifyTaxSmsCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
