package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTaxationProcess invokes the companyreg.UpdateTaxationProcess API synchronously
func (client *Client) UpdateTaxationProcess(request *UpdateTaxationProcessRequest) (response *UpdateTaxationProcessResponse, err error) {
	response = CreateUpdateTaxationProcessResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTaxationProcessWithChan invokes the companyreg.UpdateTaxationProcess API asynchronously
func (client *Client) UpdateTaxationProcessWithChan(request *UpdateTaxationProcessRequest) (<-chan *UpdateTaxationProcessResponse, <-chan error) {
	responseChan := make(chan *UpdateTaxationProcessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTaxationProcess(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTaxationProcessWithCallback invokes the companyreg.UpdateTaxationProcess API asynchronously
func (client *Client) UpdateTaxationProcessWithCallback(request *UpdateTaxationProcessRequest, callback func(response *UpdateTaxationProcessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTaxationProcessResponse
		var err error
		defer close(result)
		response, err = client.UpdateTaxationProcess(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTaxationProcessRequest is the request struct for api UpdateTaxationProcess
type UpdateTaxationProcessRequest struct {
	*requests.RpcRequest
	Period        string `position:"Query" name:"Period"`
	BizId         string `position:"Query" name:"BizId"`
	TargetProcess string `position:"Query" name:"TargetProcess"`
}

// UpdateTaxationProcessResponse is the response struct for api UpdateTaxationProcess
type UpdateTaxationProcessResponse struct {
	*responses.BaseResponse
	DeclareProcessType string                  `json:"DeclareProcessType" xml:"DeclareProcessType"`
	RequestId          string                  `json:"RequestId" xml:"RequestId"`
	TaxItemDetailList  []TaxItemDetailListItem `json:"TaxItemDetailList" xml:"TaxItemDetailList"`
}

// CreateUpdateTaxationProcessRequest creates a request to invoke UpdateTaxationProcess API
func CreateUpdateTaxationProcessRequest() (request *UpdateTaxationProcessRequest) {
	request = &UpdateTaxationProcessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "UpdateTaxationProcess", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateTaxationProcessResponse creates a response to parse from UpdateTaxationProcess response
func CreateUpdateTaxationProcessResponse() (response *UpdateTaxationProcessResponse) {
	response = &UpdateTaxationProcessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
