package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateProduce invokes the companyreg.UpdateProduce API synchronously
func (client *Client) UpdateProduce(request *UpdateProduceRequest) (response *UpdateProduceResponse, err error) {
	response = CreateUpdateProduceResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateProduceWithChan invokes the companyreg.UpdateProduce API asynchronously
func (client *Client) UpdateProduceWithChan(request *UpdateProduceRequest) (<-chan *UpdateProduceResponse, <-chan error) {
	responseChan := make(chan *UpdateProduceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateProduce(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateProduceWithCallback invokes the companyreg.UpdateProduce API asynchronously
func (client *Client) UpdateProduceWithCallback(request *UpdateProduceRequest, callback func(response *UpdateProduceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateProduceResponse
		var err error
		defer close(result)
		response, err = client.UpdateProduce(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateProduceRequest is the request struct for api UpdateProduce
type UpdateProduceRequest struct {
	*requests.RpcRequest
	ExtendMessage string `position:"Query" name:"ExtendMessage"`
	BizId         string `position:"Query" name:"BizId"`
}

// UpdateProduceResponse is the response struct for api UpdateProduce
type UpdateProduceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateProduceRequest creates a request to invoke UpdateProduce API
func CreateUpdateProduceRequest() (request *UpdateProduceRequest) {
	request = &UpdateProduceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2019-05-08", "UpdateProduce", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateProduceResponse creates a response to parse from UpdateProduce response
func CreateUpdateProduceResponse() (response *UpdateProduceResponse) {
	response = &UpdateProduceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
