package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitPartnerCompanyInformation invokes the companyreg.SubmitPartnerCompanyInformation API synchronously
func (client *Client) SubmitPartnerCompanyInformation(request *SubmitPartnerCompanyInformationRequest) (response *SubmitPartnerCompanyInformationResponse, err error) {
	response = CreateSubmitPartnerCompanyInformationResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitPartnerCompanyInformationWithChan invokes the companyreg.SubmitPartnerCompanyInformation API asynchronously
func (client *Client) SubmitPartnerCompanyInformationWithChan(request *SubmitPartnerCompanyInformationRequest) (<-chan *SubmitPartnerCompanyInformationResponse, <-chan error) {
	responseChan := make(chan *SubmitPartnerCompanyInformationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitPartnerCompanyInformation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitPartnerCompanyInformationWithCallback invokes the companyreg.SubmitPartnerCompanyInformation API asynchronously
func (client *Client) SubmitPartnerCompanyInformationWithCallback(request *SubmitPartnerCompanyInformationRequest, callback func(response *SubmitPartnerCompanyInformationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitPartnerCompanyInformationResponse
		var err error
		defer close(result)
		response, err = client.SubmitPartnerCompanyInformation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitPartnerCompanyInformationRequest is the request struct for api SubmitPartnerCompanyInformation
type SubmitPartnerCompanyInformationRequest struct {
	*requests.RpcRequest
	Uscc           string `position:"Query" name:"Uscc"`
	ContactName    string `position:"Query" name:"ContactName"`
	CompanyName    string `position:"Query" name:"CompanyName"`
	BizId          string `position:"Query" name:"BizId"`
	ContactMobile  string `position:"Query" name:"ContactMobile"`
	CompanyBizType string `position:"Query" name:"CompanyBizType"`
}

// SubmitPartnerCompanyInformationResponse is the response struct for api SubmitPartnerCompanyInformation
type SubmitPartnerCompanyInformationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSubmitPartnerCompanyInformationRequest creates a request to invoke SubmitPartnerCompanyInformation API
func CreateSubmitPartnerCompanyInformationRequest() (request *SubmitPartnerCompanyInformationRequest) {
	request = &SubmitPartnerCompanyInformationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2019-05-08", "SubmitPartnerCompanyInformation", "", "")
	request.Method = requests.POST
	return
}

// CreateSubmitPartnerCompanyInformationResponse creates a response to parse from SubmitPartnerCompanyInformation response
func CreateSubmitPartnerCompanyInformationResponse() (response *SubmitPartnerCompanyInformationResponse) {
	response = &SubmitPartnerCompanyInformationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
