package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitConsultation invokes the companyreg.SubmitConsultation API synchronously
func (client *Client) SubmitConsultation(request *SubmitConsultationRequest) (response *SubmitConsultationResponse, err error) {
	response = CreateSubmitConsultationResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitConsultationWithChan invokes the companyreg.SubmitConsultation API asynchronously
func (client *Client) SubmitConsultationWithChan(request *SubmitConsultationRequest) (<-chan *SubmitConsultationResponse, <-chan error) {
	responseChan := make(chan *SubmitConsultationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitConsultation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitConsultationWithCallback invokes the companyreg.SubmitConsultation API asynchronously
func (client *Client) SubmitConsultationWithCallback(request *SubmitConsultationRequest, callback func(response *SubmitConsultationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitConsultationResponse
		var err error
		defer close(result)
		response, err = client.SubmitConsultation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitConsultationRequest is the request struct for api SubmitConsultation
type SubmitConsultationRequest struct {
	*requests.RpcRequest
	Data             string `position:"Query" name:"Data"`
	Vcode            string `position:"Query" name:"Vcode"`
	BizCode          string `position:"Query" name:"BizCode"`
	ConsultRequestId string `position:"Query" name:"ConsultRequestId"`
	BizSubCode       string `position:"Query" name:"BizSubCode"`
}

// SubmitConsultationResponse is the response struct for api SubmitConsultation
type SubmitConsultationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSubmitConsultationRequest creates a request to invoke SubmitConsultation API
func CreateSubmitConsultationRequest() (request *SubmitConsultationRequest) {
	request = &SubmitConsultationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2019-05-08", "SubmitConsultation", "", "")
	request.Method = requests.POST
	return
}

// CreateSubmitConsultationResponse creates a response to parse from SubmitConsultation response
func CreateSubmitConsultationResponse() (response *SubmitConsultationResponse) {
	response = &SubmitConsultationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
