package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SavePayroll invokes the companyreg.SavePayroll API synchronously
func (client *Client) SavePayroll(request *SavePayrollRequest) (response *SavePayrollResponse, err error) {
	response = CreateSavePayrollResponse()
	err = client.DoAction(request, response)
	return
}

// SavePayrollWithChan invokes the companyreg.SavePayroll API asynchronously
func (client *Client) SavePayrollWithChan(request *SavePayrollRequest) (<-chan *SavePayrollResponse, <-chan error) {
	responseChan := make(chan *SavePayrollResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SavePayroll(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SavePayrollWithCallback invokes the companyreg.SavePayroll API asynchronously
func (client *Client) SavePayrollWithCallback(request *SavePayrollRequest, callback func(response *SavePayrollResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SavePayrollResponse
		var err error
		defer close(result)
		response, err = client.SavePayroll(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SavePayrollRequest is the request struct for api SavePayroll
type SavePayrollRequest struct {
	*requests.RpcRequest
	Income                           string           `position:"Query" name:"Income"`
	CorporateHousingAccumulationFund string           `position:"Query" name:"CorporateHousingAccumulationFund"`
	Period                           string           `position:"Query" name:"Period"`
	CorporateSocialInsurance         string           `position:"Query" name:"CorporateSocialInsurance"`
	IdNo                             string           `position:"Query" name:"IdNo"`
	EmployeeTime                     string           `position:"Query" name:"EmployeeTime"`
	PersonHousingAccumulationFund    string           `position:"Query" name:"PersonHousingAccumulationFund"`
	Phone                            string           `position:"Query" name:"Phone"`
	BizId                            string           `position:"Query" name:"BizId"`
	Name                             string           `position:"Query" name:"Name"`
	Id                               requests.Integer `position:"Query" name:"Id"`
	PersonSocialInsurance            string           `position:"Query" name:"PersonSocialInsurance"`
}

// SavePayrollResponse is the response struct for api SavePayroll
type SavePayrollResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateSavePayrollRequest creates a request to invoke SavePayroll API
func CreateSavePayrollRequest() (request *SavePayrollRequest) {
	request = &SavePayrollRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "SavePayroll", "", "")
	request.Method = requests.POST
	return
}

// CreateSavePayrollResponse creates a response to parse from SavePayroll response
func CreateSavePayrollResponse() (response *SavePayrollResponse) {
	response = &SavePayrollResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
