package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReSubmitIcpSolution invokes the companyreg.ReSubmitIcpSolution API synchronously
func (client *Client) ReSubmitIcpSolution(request *ReSubmitIcpSolutionRequest) (response *ReSubmitIcpSolutionResponse, err error) {
	response = CreateReSubmitIcpSolutionResponse()
	err = client.DoAction(request, response)
	return
}

// ReSubmitIcpSolutionWithChan invokes the companyreg.ReSubmitIcpSolution API asynchronously
func (client *Client) ReSubmitIcpSolutionWithChan(request *ReSubmitIcpSolutionRequest) (<-chan *ReSubmitIcpSolutionResponse, <-chan error) {
	responseChan := make(chan *ReSubmitIcpSolutionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReSubmitIcpSolution(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReSubmitIcpSolutionWithCallback invokes the companyreg.ReSubmitIcpSolution API asynchronously
func (client *Client) ReSubmitIcpSolutionWithCallback(request *ReSubmitIcpSolutionRequest, callback func(response *ReSubmitIcpSolutionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReSubmitIcpSolutionResponse
		var err error
		defer close(result)
		response, err = client.ReSubmitIcpSolution(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReSubmitIcpSolutionRequest is the request struct for api ReSubmitIcpSolution
type ReSubmitIcpSolutionRequest struct {
	*requests.RpcRequest
	BizId string `position:"Body" name:"BizId"`
}

// ReSubmitIcpSolutionResponse is the response struct for api ReSubmitIcpSolution
type ReSubmitIcpSolutionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	BizId     string `json:"BizId" xml:"BizId"`
}

// CreateReSubmitIcpSolutionRequest creates a request to invoke ReSubmitIcpSolution API
func CreateReSubmitIcpSolutionRequest() (request *ReSubmitIcpSolutionRequest) {
	request = &ReSubmitIcpSolutionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2019-05-08", "ReSubmitIcpSolution", "", "")
	request.Method = requests.POST
	return
}

// CreateReSubmitIcpSolutionResponse creates a response to parse from ReSubmitIcpSolution response
func CreateReSubmitIcpSolutionResponse() (response *ReSubmitIcpSolutionResponse) {
	response = &ReSubmitIcpSolutionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
