package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryPaymentInAdvancePersonList invokes the companyreg.QueryPaymentInAdvancePersonList API synchronously
func (client *Client) QueryPaymentInAdvancePersonList(request *QueryPaymentInAdvancePersonListRequest) (response *QueryPaymentInAdvancePersonListResponse, err error) {
	response = CreateQueryPaymentInAdvancePersonListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryPaymentInAdvancePersonListWithChan invokes the companyreg.QueryPaymentInAdvancePersonList API asynchronously
func (client *Client) QueryPaymentInAdvancePersonListWithChan(request *QueryPaymentInAdvancePersonListRequest) (<-chan *QueryPaymentInAdvancePersonListResponse, <-chan error) {
	responseChan := make(chan *QueryPaymentInAdvancePersonListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryPaymentInAdvancePersonList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryPaymentInAdvancePersonListWithCallback invokes the companyreg.QueryPaymentInAdvancePersonList API asynchronously
func (client *Client) QueryPaymentInAdvancePersonListWithCallback(request *QueryPaymentInAdvancePersonListRequest, callback func(response *QueryPaymentInAdvancePersonListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryPaymentInAdvancePersonListResponse
		var err error
		defer close(result)
		response, err = client.QueryPaymentInAdvancePersonList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryPaymentInAdvancePersonListRequest is the request struct for api QueryPaymentInAdvancePersonList
type QueryPaymentInAdvancePersonListRequest struct {
	*requests.RpcRequest
	BizId string `position:"Query" name:"BizId"`
}

// QueryPaymentInAdvancePersonListResponse is the response struct for api QueryPaymentInAdvancePersonList
type QueryPaymentInAdvancePersonListResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	List      []string `json:"List" xml:"List"`
}

// CreateQueryPaymentInAdvancePersonListRequest creates a request to invoke QueryPaymentInAdvancePersonList API
func CreateQueryPaymentInAdvancePersonListRequest() (request *QueryPaymentInAdvancePersonListRequest) {
	request = &QueryPaymentInAdvancePersonListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "QueryPaymentInAdvancePersonList", "", "")
	request.Method = requests.GET
	return
}

// CreateQueryPaymentInAdvancePersonListResponse creates a response to parse from QueryPaymentInAdvancePersonList response
func CreateQueryPaymentInAdvancePersonListResponse() (response *QueryPaymentInAdvancePersonListResponse) {
	response = &QueryPaymentInAdvancePersonListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
