package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryIcpProduceList invokes the companyreg.QueryIcpProduceList API synchronously
func (client *Client) QueryIcpProduceList(request *QueryIcpProduceListRequest) (response *QueryIcpProduceListResponse, err error) {
	response = CreateQueryIcpProduceListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryIcpProduceListWithChan invokes the companyreg.QueryIcpProduceList API asynchronously
func (client *Client) QueryIcpProduceListWithChan(request *QueryIcpProduceListRequest) (<-chan *QueryIcpProduceListResponse, <-chan error) {
	responseChan := make(chan *QueryIcpProduceListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryIcpProduceList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryIcpProduceListWithCallback invokes the companyreg.QueryIcpProduceList API asynchronously
func (client *Client) QueryIcpProduceListWithCallback(request *QueryIcpProduceListRequest, callback func(response *QueryIcpProduceListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryIcpProduceListResponse
		var err error
		defer close(result)
		response, err = client.QueryIcpProduceList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryIcpProduceListRequest is the request struct for api QueryIcpProduceList
type QueryIcpProduceListRequest struct {
	*requests.RpcRequest
	BizId    string           `position:"Query" name:"BizId"`
	PageSize requests.Integer `position:"Query" name:"PageSize"`
	Type     requests.Integer `position:"Query" name:"Type"`
	PageNum  requests.Integer `position:"Query" name:"PageNum"`
}

// QueryIcpProduceListResponse is the response struct for api QueryIcpProduceList
type QueryIcpProduceListResponse struct {
	*responses.BaseResponse
	CurrentPageNum int64       `json:"CurrentPageNum" xml:"CurrentPageNum"`
	TotalPageNum   int64       `json:"TotalPageNum" xml:"TotalPageNum"`
	PageSize       int64       `json:"PageSize" xml:"PageSize"`
	TotalItemNum   int64       `json:"TotalItemNum" xml:"TotalItemNum"`
	RequestId      string      `json:"RequestId" xml:"RequestId"`
	Data           []Trademark `json:"Data" xml:"Data"`
}

// CreateQueryIcpProduceListRequest creates a request to invoke QueryIcpProduceList API
func CreateQueryIcpProduceListRequest() (request *QueryIcpProduceListRequest) {
	request = &QueryIcpProduceListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2019-05-08", "QueryIcpProduceList", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryIcpProduceListResponse creates a response to parse from QueryIcpProduceList response
func CreateQueryIcpProduceListResponse() (response *QueryIcpProduceListResponse) {
	response = &QueryIcpProduceListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
