package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryIcpIntentionList invokes the companyreg.QueryIcpIntentionList API synchronously
func (client *Client) QueryIcpIntentionList(request *QueryIcpIntentionListRequest) (response *QueryIcpIntentionListResponse, err error) {
	response = CreateQueryIcpIntentionListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryIcpIntentionListWithChan invokes the companyreg.QueryIcpIntentionList API asynchronously
func (client *Client) QueryIcpIntentionListWithChan(request *QueryIcpIntentionListRequest) (<-chan *QueryIcpIntentionListResponse, <-chan error) {
	responseChan := make(chan *QueryIcpIntentionListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryIcpIntentionList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryIcpIntentionListWithCallback invokes the companyreg.QueryIcpIntentionList API asynchronously
func (client *Client) QueryIcpIntentionListWithCallback(request *QueryIcpIntentionListRequest, callback func(response *QueryIcpIntentionListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryIcpIntentionListResponse
		var err error
		defer close(result)
		response, err = client.QueryIcpIntentionList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryIcpIntentionListRequest is the request struct for api QueryIcpIntentionList
type QueryIcpIntentionListRequest struct {
	*requests.RpcRequest
	BizId    string           `position:"Query" name:"BizId"`
	PageSize requests.Integer `position:"Query" name:"PageSize"`
	Type     requests.Integer `position:"Query" name:"Type"`
	PageNum  requests.Integer `position:"Query" name:"PageNum"`
}

// QueryIcpIntentionListResponse is the response struct for api QueryIcpIntentionList
type QueryIcpIntentionListResponse struct {
	*responses.BaseResponse
	CurrentPageNum int64       `json:"CurrentPageNum" xml:"CurrentPageNum"`
	TotalPageNum   int64       `json:"TotalPageNum" xml:"TotalPageNum"`
	PageSize       int64       `json:"PageSize" xml:"PageSize"`
	TotalItemNum   int64       `json:"TotalItemNum" xml:"TotalItemNum"`
	RequestId      string      `json:"RequestId" xml:"RequestId"`
	Data           []Trademark `json:"Data" xml:"Data"`
}

// CreateQueryIcpIntentionListRequest creates a request to invoke QueryIcpIntentionList API
func CreateQueryIcpIntentionListRequest() (request *QueryIcpIntentionListRequest) {
	request = &QueryIcpIntentionListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2019-05-08", "QueryIcpIntentionList", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryIcpIntentionListResponse creates a response to parse from QueryIcpIntentionList response
func CreateQueryIcpIntentionListResponse() (response *QueryIcpIntentionListResponse) {
	response = &QueryIcpIntentionListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
