package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryIcpApplicationList invokes the companyreg.QueryIcpApplicationList API synchronously
func (client *Client) QueryIcpApplicationList(request *QueryIcpApplicationListRequest) (response *QueryIcpApplicationListResponse, err error) {
	response = CreateQueryIcpApplicationListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryIcpApplicationListWithChan invokes the companyreg.QueryIcpApplicationList API asynchronously
func (client *Client) QueryIcpApplicationListWithChan(request *QueryIcpApplicationListRequest) (<-chan *QueryIcpApplicationListResponse, <-chan error) {
	responseChan := make(chan *QueryIcpApplicationListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryIcpApplicationList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryIcpApplicationListWithCallback invokes the companyreg.QueryIcpApplicationList API asynchronously
func (client *Client) QueryIcpApplicationListWithCallback(request *QueryIcpApplicationListRequest, callback func(response *QueryIcpApplicationListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryIcpApplicationListResponse
		var err error
		defer close(result)
		response, err = client.QueryIcpApplicationList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryIcpApplicationListRequest is the request struct for api QueryIcpApplicationList
type QueryIcpApplicationListRequest struct {
	*requests.RpcRequest
	BizId    string           `position:"Query" name:"BizId"`
	PageSize requests.Integer `position:"Query" name:"PageSize"`
	Type     requests.Integer `position:"Query" name:"Type"`
	PageNum  requests.Integer `position:"Query" name:"PageNum"`
}

// QueryIcpApplicationListResponse is the response struct for api QueryIcpApplicationList
type QueryIcpApplicationListResponse struct {
	*responses.BaseResponse
	CurrentPageNum int64  `json:"CurrentPageNum" xml:"CurrentPageNum"`
	TotalPageNum   int64  `json:"TotalPageNum" xml:"TotalPageNum"`
	PageSize       int64  `json:"PageSize" xml:"PageSize"`
	TotalItemNum   int64  `json:"TotalItemNum" xml:"TotalItemNum"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           []Data `json:"Data" xml:"Data"`
}

// CreateQueryIcpApplicationListRequest creates a request to invoke QueryIcpApplicationList API
func CreateQueryIcpApplicationListRequest() (request *QueryIcpApplicationListRequest) {
	request = &QueryIcpApplicationListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2019-05-08", "QueryIcpApplicationList", "", "")
	request.Method = requests.GET
	return
}

// CreateQueryIcpApplicationListResponse creates a response to parse from QueryIcpApplicationList response
func CreateQueryIcpApplicationListResponse() (response *QueryIcpApplicationListResponse) {
	response = &QueryIcpApplicationListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
