package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PrintAcctgTrans invokes the companyreg.PrintAcctgTrans API synchronously
func (client *Client) PrintAcctgTrans(request *PrintAcctgTransRequest) (response *PrintAcctgTransResponse, err error) {
	response = CreatePrintAcctgTransResponse()
	err = client.DoAction(request, response)
	return
}

// PrintAcctgTransWithChan invokes the companyreg.PrintAcctgTrans API asynchronously
func (client *Client) PrintAcctgTransWithChan(request *PrintAcctgTransRequest) (<-chan *PrintAcctgTransResponse, <-chan error) {
	responseChan := make(chan *PrintAcctgTransResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PrintAcctgTrans(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PrintAcctgTransWithCallback invokes the companyreg.PrintAcctgTrans API asynchronously
func (client *Client) PrintAcctgTransWithCallback(request *PrintAcctgTransRequest, callback func(response *PrintAcctgTransResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PrintAcctgTransResponse
		var err error
		defer close(result)
		response, err = client.PrintAcctgTrans(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PrintAcctgTransRequest is the request struct for api PrintAcctgTrans
type PrintAcctgTransRequest struct {
	*requests.RpcRequest
	ShowCustomComments requests.Boolean `position:"Query" name:"ShowCustomComments"`
	PrintStyle         string           `position:"Query" name:"PrintStyle"`
	BizId              string           `position:"Query" name:"BizId"`
	PrintCount         string           `position:"Query" name:"PrintCount"`
	VoucherIds         string           `position:"Query" name:"VoucherIds"`
}

// PrintAcctgTransResponse is the response struct for api PrintAcctgTrans
type PrintAcctgTransResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Url       string `json:"Url" xml:"Url"`
}

// CreatePrintAcctgTransRequest creates a request to invoke PrintAcctgTrans API
func CreatePrintAcctgTransRequest() (request *PrintAcctgTransRequest) {
	request = &PrintAcctgTransRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "PrintAcctgTrans", "", "")
	request.Method = requests.GET
	return
}

// CreatePrintAcctgTransResponse creates a response to parse from PrintAcctgTrans response
func CreatePrintAcctgTransResponse() (response *PrintAcctgTransResponse) {
	response = &PrintAcctgTransResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
