package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPayroll invokes the companyreg.ListPayroll API synchronously
func (client *Client) ListPayroll(request *ListPayrollRequest) (response *ListPayrollResponse, err error) {
	response = CreateListPayrollResponse()
	err = client.DoAction(request, response)
	return
}

// ListPayrollWithChan invokes the companyreg.ListPayroll API asynchronously
func (client *Client) ListPayrollWithChan(request *ListPayrollRequest) (<-chan *ListPayrollResponse, <-chan error) {
	responseChan := make(chan *ListPayrollResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPayroll(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPayrollWithCallback invokes the companyreg.ListPayroll API asynchronously
func (client *Client) ListPayrollWithCallback(request *ListPayrollRequest, callback func(response *ListPayrollResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPayrollResponse
		var err error
		defer close(result)
		response, err = client.ListPayroll(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPayrollRequest is the request struct for api ListPayroll
type ListPayrollRequest struct {
	*requests.RpcRequest
	Period    string           `position:"Query" name:"Period"`
	BizId     string           `position:"Query" name:"BizId"`
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
	PageIndex requests.Integer `position:"Query" name:"PageIndex"`
}

// ListPayrollResponse is the response struct for api ListPayroll
type ListPayrollResponse struct {
	*responses.BaseResponse
	RequestId   string            `json:"RequestId" xml:"RequestId"`
	PayrollList []PayrollListItem `json:"PayrollList" xml:"PayrollList"`
}

// CreateListPayrollRequest creates a request to invoke ListPayroll API
func CreateListPayrollRequest() (request *ListPayrollRequest) {
	request = &ListPayrollRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "ListPayroll", "", "")
	request.Method = requests.GET
	return
}

// CreateListPayrollResponse creates a response to parse from ListPayroll response
func CreateListPayrollResponse() (response *ListPayrollResponse) {
	response = &ListPayrollResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
