package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLastMonthInvoice invokes the companyreg.ListLastMonthInvoice API synchronously
func (client *Client) ListLastMonthInvoice(request *ListLastMonthInvoiceRequest) (response *ListLastMonthInvoiceResponse, err error) {
	response = CreateListLastMonthInvoiceResponse()
	err = client.DoAction(request, response)
	return
}

// ListLastMonthInvoiceWithChan invokes the companyreg.ListLastMonthInvoice API asynchronously
func (client *Client) ListLastMonthInvoiceWithChan(request *ListLastMonthInvoiceRequest) (<-chan *ListLastMonthInvoiceResponse, <-chan error) {
	responseChan := make(chan *ListLastMonthInvoiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLastMonthInvoice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLastMonthInvoiceWithCallback invokes the companyreg.ListLastMonthInvoice API asynchronously
func (client *Client) ListLastMonthInvoiceWithCallback(request *ListLastMonthInvoiceRequest, callback func(response *ListLastMonthInvoiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLastMonthInvoiceResponse
		var err error
		defer close(result)
		response, err = client.ListLastMonthInvoice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLastMonthInvoiceRequest is the request struct for api ListLastMonthInvoice
type ListLastMonthInvoiceRequest struct {
	*requests.RpcRequest
	BizId    string           `position:"Query" name:"BizId"`
	PageSize requests.Integer `position:"Query" name:"PageSize"`
	Page     requests.Integer `position:"Query" name:"Page"`
}

// ListLastMonthInvoiceResponse is the response struct for api ListLastMonthInvoice
type ListLastMonthInvoiceResponse struct {
	*responses.BaseResponse
	Amount    string     `json:"Amount" xml:"Amount"`
	Count     int        `json:"Count" xml:"Count"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateListLastMonthInvoiceRequest creates a request to invoke ListLastMonthInvoice API
func CreateListLastMonthInvoiceRequest() (request *ListLastMonthInvoiceRequest) {
	request = &ListLastMonthInvoiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "ListLastMonthInvoice", "", "")
	request.Method = requests.GET
	return
}

// CreateListLastMonthInvoiceResponse creates a response to parse from ListLastMonthInvoice response
func CreateListLastMonthInvoiceResponse() (response *ListLastMonthInvoiceResponse) {
	response = &ListLastMonthInvoiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
