package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListIntentionNote invokes the companyreg.ListIntentionNote API synchronously
func (client *Client) ListIntentionNote(request *ListIntentionNoteRequest) (response *ListIntentionNoteResponse, err error) {
	response = CreateListIntentionNoteResponse()
	err = client.DoAction(request, response)
	return
}

// ListIntentionNoteWithChan invokes the companyreg.ListIntentionNote API asynchronously
func (client *Client) ListIntentionNoteWithChan(request *ListIntentionNoteRequest) (<-chan *ListIntentionNoteResponse, <-chan error) {
	responseChan := make(chan *ListIntentionNoteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListIntentionNote(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListIntentionNoteWithCallback invokes the companyreg.ListIntentionNote API asynchronously
func (client *Client) ListIntentionNoteWithCallback(request *ListIntentionNoteRequest, callback func(response *ListIntentionNoteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListIntentionNoteResponse
		var err error
		defer close(result)
		response, err = client.ListIntentionNote(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListIntentionNoteRequest is the request struct for api ListIntentionNote
type ListIntentionNoteRequest struct {
	*requests.RpcRequest
	EndTime        requests.Integer `position:"Query" name:"EndTime"`
	BeginTime      requests.Integer `position:"Query" name:"BeginTime"`
	IntentionBizId string           `position:"Query" name:"IntentionBizId"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
}

// ListIntentionNoteResponse is the response struct for api ListIntentionNote
type ListIntentionNoteResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	TotalItemNum   int    `json:"TotalItemNum" xml:"TotalItemNum"`
	CurrentPageNum int    `json:"CurrentPageNum" xml:"CurrentPageNum"`
	PageSize       int    `json:"PageSize" xml:"PageSize"`
	TotalPageNum   int    `json:"TotalPageNum" xml:"TotalPageNum"`
	Data           []Note `json:"Data" xml:"Data"`
}

// CreateListIntentionNoteRequest creates a request to invoke ListIntentionNote API
func CreateListIntentionNoteRequest() (request *ListIntentionNoteRequest) {
	request = &ListIntentionNoteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-03-06", "ListIntentionNote", "", "")
	request.Method = requests.POST
	return
}

// CreateListIntentionNoteResponse creates a response to parse from ListIntentionNote response
func CreateListIntentionNoteResponse() (response *ListIntentionNoteResponse) {
	response = &ListIntentionNoteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
