package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEnterprises invokes the companyreg.ListEnterprises API synchronously
func (client *Client) ListEnterprises(request *ListEnterprisesRequest) (response *ListEnterprisesResponse, err error) {
	response = CreateListEnterprisesResponse()
	err = client.DoAction(request, response)
	return
}

// ListEnterprisesWithChan invokes the companyreg.ListEnterprises API asynchronously
func (client *Client) ListEnterprisesWithChan(request *ListEnterprisesRequest) (<-chan *ListEnterprisesResponse, <-chan error) {
	responseChan := make(chan *ListEnterprisesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEnterprises(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEnterprisesWithCallback invokes the companyreg.ListEnterprises API asynchronously
func (client *Client) ListEnterprisesWithCallback(request *ListEnterprisesRequest, callback func(response *ListEnterprisesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEnterprisesResponse
		var err error
		defer close(result)
		response, err = client.ListEnterprises(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEnterprisesRequest is the request struct for api ListEnterprises
type ListEnterprisesRequest struct {
	*requests.RpcRequest
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	SearchKey   string           `position:"Query" name:"SearchKey"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
}

// ListEnterprisesResponse is the response struct for api ListEnterprises
type ListEnterprisesResponse struct {
	*responses.BaseResponse
	RequestId       string                `json:"RequestId" xml:"RequestId"`
	EnterprisesList []EnterprisesListItem `json:"EnterprisesList" xml:"EnterprisesList"`
}

// CreateListEnterprisesRequest creates a request to invoke ListEnterprises API
func CreateListEnterprisesRequest() (request *ListEnterprisesRequest) {
	request = &ListEnterprisesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "ListEnterprises", "", "")
	request.Method = requests.GET
	return
}

// CreateListEnterprisesResponse creates a response to parse from ListEnterprises response
func CreateListEnterprisesResponse() (response *ListEnterprisesResponse) {
	response = &ListEnterprisesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
