package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCashJournal invokes the companyreg.ListCashJournal API synchronously
func (client *Client) ListCashJournal(request *ListCashJournalRequest) (response *ListCashJournalResponse, err error) {
	response = CreateListCashJournalResponse()
	err = client.DoAction(request, response)
	return
}

// ListCashJournalWithChan invokes the companyreg.ListCashJournal API asynchronously
func (client *Client) ListCashJournalWithChan(request *ListCashJournalRequest) (<-chan *ListCashJournalResponse, <-chan error) {
	responseChan := make(chan *ListCashJournalResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCashJournal(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCashJournalWithCallback invokes the companyreg.ListCashJournal API asynchronously
func (client *Client) ListCashJournalWithCallback(request *ListCashJournalRequest, callback func(response *ListCashJournalResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCashJournalResponse
		var err error
		defer close(result)
		response, err = client.ListCashJournal(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCashJournalRequest is the request struct for api ListCashJournal
type ListCashJournalRequest struct {
	*requests.RpcRequest
	Period    string           `position:"Query" name:"Period"`
	BizId     string           `position:"Query" name:"BizId"`
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
	PageIndex requests.Integer `position:"Query" name:"PageIndex"`
}

// ListCashJournalResponse is the response struct for api ListCashJournal
type ListCashJournalResponse struct {
	*responses.BaseResponse
	RequestId       string                `json:"RequestId" xml:"RequestId"`
	CashJournalList []CashJournalListItem `json:"CashJournalList" xml:"CashJournalList"`
}

// CreateListCashJournalRequest creates a request to invoke ListCashJournal API
func CreateListCashJournalRequest() (request *ListCashJournalRequest) {
	request = &ListCashJournalRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "ListCashJournal", "", "")
	request.Method = requests.GET
	return
}

// CreateListCashJournalResponse creates a response to parse from ListCashJournal response
func CreateListCashJournalResponse() (response *ListCashJournalResponse) {
	response = &ListCashJournalResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
