package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSsoUserInfo invokes the companyreg.GetSsoUserInfo API synchronously
func (client *Client) GetSsoUserInfo(request *GetSsoUserInfoRequest) (response *GetSsoUserInfoResponse, err error) {
	response = CreateGetSsoUserInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetSsoUserInfoWithChan invokes the companyreg.GetSsoUserInfo API asynchronously
func (client *Client) GetSsoUserInfoWithChan(request *GetSsoUserInfoRequest) (<-chan *GetSsoUserInfoResponse, <-chan error) {
	responseChan := make(chan *GetSsoUserInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSsoUserInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSsoUserInfoWithCallback invokes the companyreg.GetSsoUserInfo API asynchronously
func (client *Client) GetSsoUserInfoWithCallback(request *GetSsoUserInfoRequest, callback func(response *GetSsoUserInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSsoUserInfoResponse
		var err error
		defer close(result)
		response, err = client.GetSsoUserInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSsoUserInfoRequest is the request struct for api GetSsoUserInfo
type GetSsoUserInfoRequest struct {
	*requests.RpcRequest
	OpsAppKey string `position:"Query" name:"OpsAppKey"`
	Token     string `position:"Query" name:"Token"`
}

// GetSsoUserInfoResponse is the response struct for api GetSsoUserInfo
type GetSsoUserInfoResponse struct {
	*responses.BaseResponse
	OpsAppKey      string `json:"OpsAppKey" xml:"OpsAppKey"`
	AliUserId      string `json:"AliUserId" xml:"AliUserId"`
	RamUserId      int64  `json:"RamUserId" xml:"RamUserId"`
	AliUserAccount string `json:"AliUserAccount" xml:"AliUserAccount"`
	RamUserAccount string `json:"RamUserAccount" xml:"RamUserAccount"`
	RamUserName    string `json:"RamUserName" xml:"RamUserName"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	UserType       int    `json:"UserType" xml:"UserType"`
}

// CreateGetSsoUserInfoRequest creates a request to invoke GetSsoUserInfo API
func CreateGetSsoUserInfoRequest() (request *GetSsoUserInfoRequest) {
	request = &GetSsoUserInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "GetSsoUserInfo", "", "")
	request.Method = requests.GET
	return
}

// CreateGetSsoUserInfoResponse creates a response to parse from GetSsoUserInfo response
func CreateGetSsoUserInfoResponse() (response *GetSsoUserInfoResponse) {
	response = &GetSsoUserInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
