package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetQuarterIncomeStatementInfo invokes the companyreg.GetQuarterIncomeStatementInfo API synchronously
func (client *Client) GetQuarterIncomeStatementInfo(request *GetQuarterIncomeStatementInfoRequest) (response *GetQuarterIncomeStatementInfoResponse, err error) {
	response = CreateGetQuarterIncomeStatementInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetQuarterIncomeStatementInfoWithChan invokes the companyreg.GetQuarterIncomeStatementInfo API asynchronously
func (client *Client) GetQuarterIncomeStatementInfoWithChan(request *GetQuarterIncomeStatementInfoRequest) (<-chan *GetQuarterIncomeStatementInfoResponse, <-chan error) {
	responseChan := make(chan *GetQuarterIncomeStatementInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetQuarterIncomeStatementInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetQuarterIncomeStatementInfoWithCallback invokes the companyreg.GetQuarterIncomeStatementInfo API asynchronously
func (client *Client) GetQuarterIncomeStatementInfoWithCallback(request *GetQuarterIncomeStatementInfoRequest, callback func(response *GetQuarterIncomeStatementInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetQuarterIncomeStatementInfoResponse
		var err error
		defer close(result)
		response, err = client.GetQuarterIncomeStatementInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetQuarterIncomeStatementInfoRequest is the request struct for api GetQuarterIncomeStatementInfo
type GetQuarterIncomeStatementInfoRequest struct {
	*requests.RpcRequest
	Period    string           `position:"Query" name:"Period"`
	BizId     string           `position:"Query" name:"BizId"`
	IsQuarter requests.Boolean `position:"Query" name:"IsQuarter"`
}

// GetQuarterIncomeStatementInfoResponse is the response struct for api GetQuarterIncomeStatementInfo
type GetQuarterIncomeStatementInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Url       string `json:"Url" xml:"Url"`
}

// CreateGetQuarterIncomeStatementInfoRequest creates a request to invoke GetQuarterIncomeStatementInfo API
func CreateGetQuarterIncomeStatementInfoRequest() (request *GetQuarterIncomeStatementInfoRequest) {
	request = &GetQuarterIncomeStatementInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "GetQuarterIncomeStatementInfo", "", "")
	request.Method = requests.GET
	return
}

// CreateGetQuarterIncomeStatementInfoResponse creates a response to parse from GetQuarterIncomeStatementInfo response
func CreateGetQuarterIncomeStatementInfoResponse() (response *GetQuarterIncomeStatementInfoResponse) {
	response = &GetQuarterIncomeStatementInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
