package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInvoiceInfo invokes the companyreg.GetInvoiceInfo API synchronously
func (client *Client) GetInvoiceInfo(request *GetInvoiceInfoRequest) (response *GetInvoiceInfoResponse, err error) {
	response = CreateGetInvoiceInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetInvoiceInfoWithChan invokes the companyreg.GetInvoiceInfo API asynchronously
func (client *Client) GetInvoiceInfoWithChan(request *GetInvoiceInfoRequest) (<-chan *GetInvoiceInfoResponse, <-chan error) {
	responseChan := make(chan *GetInvoiceInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInvoiceInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInvoiceInfoWithCallback invokes the companyreg.GetInvoiceInfo API asynchronously
func (client *Client) GetInvoiceInfoWithCallback(request *GetInvoiceInfoRequest, callback func(response *GetInvoiceInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInvoiceInfoResponse
		var err error
		defer close(result)
		response, err = client.GetInvoiceInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInvoiceInfoRequest is the request struct for api GetInvoiceInfo
type GetInvoiceInfoRequest struct {
	*requests.RpcRequest
	BizId string           `position:"Query" name:"BizId"`
	Id    requests.Integer `position:"Query" name:"Id"`
}

// GetInvoiceInfoResponse is the response struct for api GetInvoiceInfo
type GetInvoiceInfoResponse struct {
	*responses.BaseResponse
	AcctgPeriod               string           `json:"AcctgPeriod" xml:"AcctgPeriod"`
	BaseTotalAmountWithTax    string           `json:"BaseTotalAmountWithTax" xml:"BaseTotalAmountWithTax"`
	BaseTotalAmountWithoutTax string           `json:"BaseTotalAmountWithoutTax" xml:"BaseTotalAmountWithoutTax"`
	BaseTotalTax              string           `json:"BaseTotalTax" xml:"BaseTotalTax"`
	BizDate                   int64            `json:"BizDate" xml:"BizDate"`
	Comments                  string           `json:"Comments" xml:"Comments"`
	CreatedStamp              int64            `json:"CreatedStamp" xml:"CreatedStamp"`
	DueDate                   int64            `json:"DueDate" xml:"DueDate"`
	ElecInvoiceUrl            string           `json:"ElecInvoiceUrl" xml:"ElecInvoiceUrl"`
	Id                        int64            `json:"Id" xml:"Id"`
	InvoiceCode               string           `json:"InvoiceCode" xml:"InvoiceCode"`
	InvoiceNo                 string           `json:"InvoiceNo" xml:"InvoiceNo"`
	IsElectronic              bool             `json:"IsElectronic" xml:"IsElectronic"`
	IsAuth                    bool             `json:"IsAuth" xml:"IsAuth"`
	IsFee                     bool             `json:"IsFee" xml:"IsFee"`
	OrgName                   string           `json:"OrgName" xml:"OrgName"`
	RequestId                 string           `json:"RequestId" xml:"RequestId"`
	SimulationCertified       bool             `json:"SimulationCertified" xml:"SimulationCertified"`
	TaxNo                     string           `json:"TaxNo" xml:"TaxNo"`
	TaxPct                    string           `json:"TaxPct" xml:"TaxPct"`
	Type                      string           `json:"Type" xml:"Type"`
	Payer                     string           `json:"Payer" xml:"Payer"`
	CanUpdate                 bool             `json:"CanUpdate" xml:"CanUpdate"`
	LabelData                 string           `json:"LabelData" xml:"LabelData"`
	BuyMethod                 BuyMethod        `json:"BuyMethod" xml:"BuyMethod"`
	BuyTarget                 BuyTarget        `json:"BuyTarget" xml:"BuyTarget"`
	CustVendorId              CustVendorId     `json:"CustVendorId" xml:"CustVendorId"`
	FixedAssetType            FixedAssetType   `json:"FixedAssetType" xml:"FixedAssetType"`
	IncomeOutType             IncomeOutType    `json:"IncomeOutType" xml:"IncomeOutType"`
	Kind                      Kind             `json:"Kind" xml:"Kind"`
	PayMethod                 PayMethod        `json:"PayMethod" xml:"PayMethod"`
	ShellMethod               ShellMethod      `json:"ShellMethod" xml:"ShellMethod"`
	Use                       Use              `json:"Use" xml:"Use"`
	Details                   []DetailsItem    `json:"Details" xml:"Details"`
	VoucherTransList          []AcctgTransList `json:"VoucherTransList" xml:"VoucherTransList"`
}

// CreateGetInvoiceInfoRequest creates a request to invoke GetInvoiceInfo API
func CreateGetInvoiceInfoRequest() (request *GetInvoiceInfoRequest) {
	request = &GetInvoiceInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "GetInvoiceInfo", "", "")
	request.Method = requests.GET
	return
}

// CreateGetInvoiceInfoResponse creates a response to parse from GetInvoiceInfo response
func CreateGetInvoiceInfoResponse() (response *GetInvoiceInfoResponse) {
	response = &GetInvoiceInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
