package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInitFlow invokes the companyreg.GetInitFlow API synchronously
func (client *Client) GetInitFlow(request *GetInitFlowRequest) (response *GetInitFlowResponse, err error) {
	response = CreateGetInitFlowResponse()
	err = client.DoAction(request, response)
	return
}

// GetInitFlowWithChan invokes the companyreg.GetInitFlow API asynchronously
func (client *Client) GetInitFlowWithChan(request *GetInitFlowRequest) (<-chan *GetInitFlowResponse, <-chan error) {
	responseChan := make(chan *GetInitFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInitFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInitFlowWithCallback invokes the companyreg.GetInitFlow API asynchronously
func (client *Client) GetInitFlowWithCallback(request *GetInitFlowRequest, callback func(response *GetInitFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInitFlowResponse
		var err error
		defer close(result)
		response, err = client.GetInitFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInitFlowRequest is the request struct for api GetInitFlow
type GetInitFlowRequest struct {
	*requests.RpcRequest
	BizId string `position:"Query" name:"BizId"`
}

// GetInitFlowResponse is the response struct for api GetInitFlow
type GetInitFlowResponse struct {
	*responses.BaseResponse
	FlowStatus string         `json:"FlowStatus" xml:"FlowStatus"`
	RequestId  string         `json:"RequestId" xml:"RequestId"`
	NodeList   []NodeListItem `json:"NodeList" xml:"NodeList"`
}

// CreateGetInitFlowRequest creates a request to invoke GetInitFlow API
func CreateGetInitFlowRequest() (request *GetInitFlowRequest) {
	request = &GetInitFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "GetInitFlow", "", "")
	request.Method = requests.GET
	return
}

// CreateGetInitFlowResponse creates a response to parse from GetInitFlow response
func CreateGetInitFlowResponse() (response *GetInitFlowResponse) {
	response = &GetInitFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
