package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFee invokes the companyreg.GetFee API synchronously
func (client *Client) GetFee(request *GetFeeRequest) (response *GetFeeResponse, err error) {
	response = CreateGetFeeResponse()
	err = client.DoAction(request, response)
	return
}

// GetFeeWithChan invokes the companyreg.GetFee API asynchronously
func (client *Client) GetFeeWithChan(request *GetFeeRequest) (<-chan *GetFeeResponse, <-chan error) {
	responseChan := make(chan *GetFeeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFee(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFeeWithCallback invokes the companyreg.GetFee API asynchronously
func (client *Client) GetFeeWithCallback(request *GetFeeRequest, callback func(response *GetFeeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFeeResponse
		var err error
		defer close(result)
		response, err = client.GetFee(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFeeRequest is the request struct for api GetFee
type GetFeeRequest struct {
	*requests.RpcRequest
	BizId string           `position:"Query" name:"BizId"`
	Id    requests.Integer `position:"Query" name:"Id"`
}

// GetFeeResponse is the response struct for api GetFee
type GetFeeResponse struct {
	*responses.BaseResponse
	AcctgPeriod               string           `json:"AcctgPeriod" xml:"AcctgPeriod"`
	BaseTotalAmount           string           `json:"BaseTotalAmount" xml:"BaseTotalAmount"`
	BaseTotalAmountWithoutTax string           `json:"BaseTotalAmountWithoutTax" xml:"BaseTotalAmountWithoutTax"`
	BaseTotalTax              string           `json:"BaseTotalTax" xml:"BaseTotalTax"`
	CreatedStamp              int64            `json:"CreatedStamp" xml:"CreatedStamp"`
	Id                        int64            `json:"Id" xml:"Id"`
	RequestId                 string           `json:"RequestId" xml:"RequestId"`
	Url                       string           `json:"Url" xml:"Url"`
	Payer                     string           `json:"Payer" xml:"Payer"`
	CanUpdate                 bool             `json:"CanUpdate" xml:"CanUpdate"`
	LabelData                 string           `json:"LabelData" xml:"LabelData"`
	FeeTypeEnum               FeeTypeEnum      `json:"FeeTypeEnum" xml:"FeeTypeEnum"`
	Kind                      Kind             `json:"Kind" xml:"Kind"`
	PayMethod                 PayMethod        `json:"PayMethod" xml:"PayMethod"`
	Use                       Use              `json:"Use" xml:"Use"`
	VoucherTransList          []AcctgTransList `json:"VoucherTransList" xml:"VoucherTransList"`
}

// CreateGetFeeRequest creates a request to invoke GetFee API
func CreateGetFeeRequest() (request *GetFeeRequest) {
	request = &GetFeeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "GetFee", "", "")
	request.Method = requests.GET
	return
}

// CreateGetFeeResponse creates a response to parse from GetFee response
func CreateGetFeeResponse() (response *GetFeeResponse) {
	response = &GetFeeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
