package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEmployeeCountSum invokes the companyreg.GetEmployeeCountSum API synchronously
func (client *Client) GetEmployeeCountSum(request *GetEmployeeCountSumRequest) (response *GetEmployeeCountSumResponse, err error) {
	response = CreateGetEmployeeCountSumResponse()
	err = client.DoAction(request, response)
	return
}

// GetEmployeeCountSumWithChan invokes the companyreg.GetEmployeeCountSum API asynchronously
func (client *Client) GetEmployeeCountSumWithChan(request *GetEmployeeCountSumRequest) (<-chan *GetEmployeeCountSumResponse, <-chan error) {
	responseChan := make(chan *GetEmployeeCountSumResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEmployeeCountSum(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEmployeeCountSumWithCallback invokes the companyreg.GetEmployeeCountSum API asynchronously
func (client *Client) GetEmployeeCountSumWithCallback(request *GetEmployeeCountSumRequest, callback func(response *GetEmployeeCountSumResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEmployeeCountSumResponse
		var err error
		defer close(result)
		response, err = client.GetEmployeeCountSum(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEmployeeCountSumRequest is the request struct for api GetEmployeeCountSum
type GetEmployeeCountSumRequest struct {
	*requests.RpcRequest
	Period string `position:"Query" name:"Period"`
	BizId  string `position:"Query" name:"BizId"`
}

// GetEmployeeCountSumResponse is the response struct for api GetEmployeeCountSum
type GetEmployeeCountSumResponse struct {
	*responses.BaseResponse
	TotalEmployee string `json:"TotalEmployee" xml:"TotalEmployee"`
	TotalAmount   string `json:"TotalAmount" xml:"TotalAmount"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
}

// CreateGetEmployeeCountSumRequest creates a request to invoke GetEmployeeCountSum API
func CreateGetEmployeeCountSumRequest() (request *GetEmployeeCountSumRequest) {
	request = &GetEmployeeCountSumRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "GetEmployeeCountSum", "", "")
	request.Method = requests.GET
	return
}

// CreateGetEmployeeCountSumResponse creates a response to parse from GetEmployeeCountSum response
func CreateGetEmployeeCountSumResponse() (response *GetEmployeeCountSumResponse) {
	response = &GetEmployeeCountSumResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
