package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetElementEstimate invokes the companyreg.GetElementEstimate API synchronously
func (client *Client) GetElementEstimate(request *GetElementEstimateRequest) (response *GetElementEstimateResponse, err error) {
	response = CreateGetElementEstimateResponse()
	err = client.DoAction(request, response)
	return
}

// GetElementEstimateWithChan invokes the companyreg.GetElementEstimate API asynchronously
func (client *Client) GetElementEstimateWithChan(request *GetElementEstimateRequest) (<-chan *GetElementEstimateResponse, <-chan error) {
	responseChan := make(chan *GetElementEstimateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetElementEstimate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetElementEstimateWithCallback invokes the companyreg.GetElementEstimate API asynchronously
func (client *Client) GetElementEstimateWithCallback(request *GetElementEstimateRequest, callback func(response *GetElementEstimateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetElementEstimateResponse
		var err error
		defer close(result)
		response, err = client.GetElementEstimate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetElementEstimateRequest is the request struct for api GetElementEstimate
type GetElementEstimateRequest struct {
	*requests.RpcRequest
	Period string `position:"Query" name:"Period"`
	BizId  string `position:"Query" name:"BizId"`
}

// GetElementEstimateResponse is the response struct for api GetElementEstimate
type GetElementEstimateResponse struct {
	*responses.BaseResponse
	Type      string `json:"Type" xml:"Type"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateGetElementEstimateRequest creates a request to invoke GetElementEstimate API
func CreateGetElementEstimateRequest() (request *GetElementEstimateRequest) {
	request = &GetElementEstimateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "GetElementEstimate", "", "")
	request.Method = requests.GET
	return
}

// CreateGetElementEstimateResponse creates a response to parse from GetElementEstimate response
func CreateGetElementEstimateResponse() (response *GetElementEstimateResponse) {
	response = &GetElementEstimateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
