package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAppletIntelligent invokes the companyreg.GetAppletIntelligent API synchronously
func (client *Client) GetAppletIntelligent(request *GetAppletIntelligentRequest) (response *GetAppletIntelligentResponse, err error) {
	response = CreateGetAppletIntelligentResponse()
	err = client.DoAction(request, response)
	return
}

// GetAppletIntelligentWithChan invokes the companyreg.GetAppletIntelligent API asynchronously
func (client *Client) GetAppletIntelligentWithChan(request *GetAppletIntelligentRequest) (<-chan *GetAppletIntelligentResponse, <-chan error) {
	responseChan := make(chan *GetAppletIntelligentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAppletIntelligent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAppletIntelligentWithCallback invokes the companyreg.GetAppletIntelligent API asynchronously
func (client *Client) GetAppletIntelligentWithCallback(request *GetAppletIntelligentRequest, callback func(response *GetAppletIntelligentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAppletIntelligentResponse
		var err error
		defer close(result)
		response, err = client.GetAppletIntelligent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAppletIntelligentRequest is the request struct for api GetAppletIntelligent
type GetAppletIntelligentRequest struct {
	*requests.RpcRequest
	Period string `position:"Query" name:"Period"`
	BizId  string `position:"Query" name:"BizId"`
}

// GetAppletIntelligentResponse is the response struct for api GetAppletIntelligent
type GetAppletIntelligentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateGetAppletIntelligentRequest creates a request to invoke GetAppletIntelligent API
func CreateGetAppletIntelligentRequest() (request *GetAppletIntelligentRequest) {
	request = &GetAppletIntelligentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "GetAppletIntelligent", "", "")
	request.Method = requests.GET
	return
}

// CreateGetAppletIntelligentResponse creates a response to parse from GetAppletIntelligent response
func CreateGetAppletIntelligentResponse() (response *GetAppletIntelligentResponse) {
	response = &GetAppletIntelligentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
